/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.logging.Logger;
import org.jboss.virtual.plugins.context.zip.ZipFileWrapper;

public class ZipFileLockReaper {
    private static final Logger log = Logger.getLogger(ZipFileLockReaper.class);
    private static final int PERIOD = 5000;
    private static final int TIMER_PERIOD = 1000;
    private static final int TIMER_UNUSED_PERIOD = 30000;
    private static ZipFileLockReaper singleton;
    private Queue<ZipFileWrapper> monitored = new ConcurrentLinkedQueue<ZipFileWrapper>();
    private int monitoredCount = 0;
    private Timer timer;
    private long lastUsed;

    private ZipFileLockReaper() {
    }

    public static synchronized ZipFileLockReaper getInstance() {
        if (singleton == null) {
            singleton = new ZipFileLockReaper();
        }
        return singleton;
    }

    public synchronized void register(ZipFileWrapper w) {
        this.monitored.add(w);
        ++this.monitoredCount;
        if (this.timer == null) {
            this.timer = new Timer("ZipFile Lock Reaper", true);
            this.timer.schedule((TimerTask)new ReaperTimerTask(), 1000L, 1000L);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered: " + w));
        }
    }

    public synchronized void unregister(ZipFileWrapper w) {
        this.monitored.remove(w);
        --this.monitoredCount;
        this.lastUsed = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unregistered: " + w));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(ZipFileWrapper zipFileWrapper) throws IOException {
        ZipFileLockReaper zipFileLockReaper = this;
        synchronized (zipFileLockReaper) {
            for (ZipFileWrapper w : this.monitored) {
                w.deleteFile(zipFileWrapper);
            }
        }
    }

    class ReaperTimerTask
    extends TimerTask {
        ReaperTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)"Timer called");
            }
            long now = System.currentTimeMillis();
            ZipFileLockReaper zipFileLockReaper = ZipFileLockReaper.this;
            synchronized (zipFileLockReaper) {
                if (ZipFileLockReaper.this.monitoredCount == 0) {
                    if (now - ZipFileLockReaper.this.lastUsed > 30000L) {
                        ZipFileLockReaper.this.timer.cancel();
                        ZipFileLockReaper.this.timer = null;
                        if (trace) {
                            log.trace((Object)"Cancelled the timer");
                        }
                    }
                    return;
                }
            }
            for (ZipFileWrapper w : ZipFileLockReaper.this.monitored) {
                if (w.getReferenceCount() > 0 || now - w.getLastUsed() <= 5000L) continue;
                try {
                    w.closeZipFile();
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Asynchronously closed an unused ZipFile: " + w));
                }
                catch (Exception ignored) {
                    log.debug((Object)("IGNORING: Failed to close ZipFile: " + w), (Throwable)ignored);
                }
            }
        }
    }
}

