/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.VFSUtils;

public final class TempFileProvider
implements Closeable {
    private static final String JBOSS_TMP_DIR_PROPERTY = "jboss.server.temp.dir";
    private static final String JVM_TMP_DIR_PROPERTY = "java.io.tmpdir";
    private static final File TMP_ROOT;
    private static final int RETRIES = 10;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final File providerRoot;
    private final ScheduledExecutorService executor;
    private static final Random rng;

    public static TempFileProvider create(String providerType, ScheduledExecutorService executor) throws IOException {
        return new TempFileProvider(TempFileProvider.createTempDir(providerType, "", TMP_ROOT), executor);
    }

    private TempFileProvider(File providerRoot, ScheduledExecutorService executor) {
        this.providerRoot = providerRoot;
        this.executor = executor;
    }

    public TempDir createTempDir(String originalName) throws IOException {
        if (!this.open.get()) {
            throw new IOException("Temp file provider closed");
        }
        String name = TempFileProvider.createTempName(originalName + "-", "");
        File f = new File(this.providerRoot, name);
        for (int i = 0; i < 10; ++i) {
            if (!f.mkdir()) continue;
            return new TempDir(this, f);
        }
        IOException eo = new IOException("Could not create directory after 10 attempts");
        throw eo;
    }

    private static File createTempDir(String prefix, String suffix, File root) throws IOException {
        for (int i = 0; i < 10; ++i) {
            File f = new File(root, TempFileProvider.createTempName(prefix, suffix));
            if (!f.mkdir()) continue;
            return f;
        }
        IOException eo = new IOException("Could not create directory after 10 attempts");
        throw eo;
    }

    static String createTempName(String prefix, String suffix) {
        return prefix + Long.toHexString(rng.nextLong()) + suffix;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            new DeleteTask(this.providerRoot).run();
        }
    }

    protected void finalize() {
        VFSUtils.safeClose((Closeable)this);
    }

    static {
        String configTmpDir = System.getProperty(JBOSS_TMP_DIR_PROPERTY);
        if (configTmpDir == null) {
            configTmpDir = System.getProperty(JVM_TMP_DIR_PROPERTY);
        }
        try {
            TMP_ROOT = new File(configTmpDir, "vfs");
            TMP_ROOT.mkdirs();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't set up temp file provider", e);
        }
        rng = new Random();
    }

    class DeleteTask
    implements Runnable {
        private final File root;

        public DeleteTask(File root) {
            this.root = root;
        }

        @Override
        public void run() {
            if (!VFSUtils.recursiveDelete(this.root)) {
                TempFileProvider.this.executor.schedule(this, 30L, TimeUnit.SECONDS);
            }
        }
    }
}

