/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer.jmx;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import org.jboss.annotation.factory.AnnotationProxy;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.annotations.AbstractAnnotationPlugin;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.AnnotatedInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMXAnnotationPlugin<T extends AnnotatedInfo>
extends AbstractAnnotationPlugin<T, JMX> {
    protected JMXAnnotationPlugin() {
        super(JMX.class);
    }

    protected boolean isCleanup() {
        return true;
    }

    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData metaData, JMX jmx, KernelControllerContext context) throws Throwable {
        Class<?> exposedInterface = jmx.exposedInterface();
        if (exposedInterface == null || Void.TYPE.equals(exposedInterface)) {
            exposedInterface = this.getExposedInterface(info);
        }
        if (exposedInterface == null || !exposedInterface.isInterface()) {
            throw new IllegalArgumentException("Illegal exposed interface: " + exposedInterface);
        }
        String name = this.createObjectName((ControllerContext)context, info, jmx);
        String property = this.getName(info);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Exposing " + context.getName() + "." + property + " (" + exposedInterface.getName() + ") via objectName: " + name));
        }
        String id = this.createId(context, info, jmx);
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)id, (String)exposedInterface.getName());
        builder.addAnnotation((Annotation)this.wrapJMX(jmx, name, exposedInterface));
        builder.setConstructorValue((ValueMetaData)new AbstractDependencyValueMetaData(context.getName(), property));
        KernelController controller = (KernelController)context.getController();
        controller.install(builder.getBeanMetaData());
        return null;
    }

    protected String createId(KernelControllerContext context, T info, JMX jmx) {
        return context.getName() + "." + this.getName(info) + "." + jmx.hashCode();
    }

    protected JMX wrapJMX(JMX original, String name, Class<?> exposedInterface) throws Throwable {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("exposedInterface", exposedInterface);
        attributes.put("name", name);
        attributes.put("registerDirectly", original.registerDirectly());
        return (JMX)AnnotationProxy.createProxy(attributes, JMX.class);
    }

    protected void internalCleanAnnotation(T info, MetaData metaData, JMX jmx, KernelControllerContext context) throws Throwable {
        String id = this.createId(context, info, jmx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing " + context.getName() + "." + this.getName(info) + " via id: " + id));
        }
        Controller controller = context.getController();
        controller.uninstall((Object)id);
    }

    protected abstract Class<?> getExposedInterface(T var1);

    protected abstract String getName(T var1);

    protected static String getJmxName(JMX jmx) {
        String jmxName = jmx.name();
        if (jmxName != null && jmxName.length() > 0) {
            return jmxName;
        }
        return null;
    }

    protected String createObjectName(ControllerContext context, T info, JMX jmx) throws Exception {
        String name;
        String jmxName = JMXAnnotationPlugin.getJmxName(jmx);
        if (jmxName != null) {
            return jmxName;
        }
        String objectName = name = context.getName().toString();
        if (!name.contains(":")) {
            objectName = "jboss.pojo:name='" + name + "'";
        }
        return objectName + ",attribute=" + this.getName(info);
    }
}

