/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.basic;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profile.basic.ProfileImpl;


/**
 * An basic ProfileService impl for loading server deployments
 * that uses the basic ProfileImpl.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision$
 */
public class ProfileServiceImpl
   implements ProfileService
{
   private String name;
   private String profileRoot;
   private Profile defaultImpl;
   private ManagementView mgtView;
   private DeploymentManager deployMgr;

   public ProfileServiceImpl(String name) throws IOException
   {
      this.name = name;
   }
   // Properties ------------------------
   
   public String getName()
   {
      return this.name;
   }
   public void setName(String name)
   {
      this.name = name;
   }
   public String getProfileRoot()
   {
      return this.profileRoot;
   }
   public void setProfileRoot(String profileRoot)
   {
      this.profileRoot = profileRoot;
   }

   public void start()
   {
      ProfileKey key = new ProfileKey(name);
      defaultImpl = createProfile(key);
   }

   /**
    * Create default profile.
    *
    * @param key the profile key
    * @return new profile instance
    */
   protected Profile createProfile(ProfileKey key)
   {
      return new ProfileImpl(profileRoot, key);
   }

   // ProfileService implementation --------------------
   public String[] getDomains()
   {
      return new String[]{ProfileKey.DEFAULT};
   }

   public Collection<ProfileKey> getProfileKeys()
   {
      Collection<ProfileKey> keys = new HashSet<ProfileKey>();
      keys.add(new ProfileKey(null));
      return keys;
   }

   /**
    * Always returns the default profile.
    */
   public Profile getProfile(ProfileKey key)
      throws NoSuchProfileException
   {
      return defaultImpl;
   }
   public Profile getActiveProfile()
      throws NoSuchProfileException
   {
      return defaultImpl;   
   }

   public String[] getProfileDeploymentNames(ProfileKey key)
      throws NoSuchProfileException
   {
      return new String[]{"default"};
   }

   public ManagementView getViewManager()
   {
      return mgtView;
   }
   public void setViewManager(ManagementView mgtView)
   {
      this.mgtView = mgtView;
   }

   public DeploymentManager getDeploymentManager()
   {
      return deployMgr;
   }
   public void setDeploymentManager(DeploymentManager deployMgr)
   {
      this.deployMgr = deployMgr;
   }

   // Admin of profiles @todo could be an option plugin
   public Profile newProfile(ProfileKey key)
   {
      return new ProfileImpl(profileRoot, key);
   }

   public void removeProfile(ProfileKey key)
      throws NoSuchProfileException
   {
   }
}

