/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.IOException;
import java.util.Collection;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileRepository;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profile.repository.ProfileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceImpl
implements ProfileService {
    private static final Logger log = Logger.getLogger(ProfileServiceImpl.class);
    private String name;
    private ProfileRepository profileRepository;
    private DeploymentRepository deploymentRepository;
    private Profile profile;
    private ManagementView mgtView;
    private DeploymentManager deployMgr;
    private String version;

    public ProfileServiceImpl(String name) throws IOException {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    public void setProfileRepository(ProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public DeploymentRepository getDeploymentRepository() {
        return this.deploymentRepository;
    }

    public void setDeploymentRepository(DeploymentRepository repository) {
        this.deploymentRepository = repository;
    }

    public void start() throws Exception {
        if (this.profileRepository == null) {
            throw new IllegalStateException("No profileRepository specified");
        }
        ProfileKey key = new ProfileKey(this.name);
        Profile profile = this.getProfile(key);
        log.info((Object)("Loaded profile: " + profile));
    }

    @Override
    public String[] getDomains() {
        String[] domains = new String[]{"default"};
        return domains;
    }

    @Override
    public Collection<ProfileKey> getProfileKeys() {
        Collection<ProfileKey> keys = this.profileRepository.getProfileKeys();
        return keys;
    }

    @Override
    public Profile getProfile(ProfileKey key) throws NoSuchProfileException {
        if (this.profileRepository == null) {
            throw new IllegalStateException("No profileRepository specified");
        }
        if (this.profile != null && (key.isDefaultKey() || this.profile.getKey().equals(key))) {
            return this.profile;
        }
        try {
            this.deploymentRepository = this.profileRepository.getProfileDeploymentRepository(key);
        }
        catch (NoSuchProfileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NoSuchProfileException("Failed to obtain deployment repository for: " + key, e);
        }
        log.info((Object)("Loading profile: " + this.name + " from: " + this.deploymentRepository));
        this.profile = new ProfileImpl(this.deploymentRepository, key);
        return this.profile;
    }

    @Override
    public Profile getActiveProfile() throws NoSuchProfileException {
        return this.profile;
    }

    @Override
    public String[] getProfileDeploymentNames(ProfileKey key) throws NoSuchProfileException {
        String[] names = new String[]{"default"};
        return names;
    }

    @Override
    public ManagementView getViewManager() {
        return this.mgtView;
    }

    public void setViewManager(ManagementView mgtView) {
        this.mgtView = mgtView;
    }

    @Override
    public DeploymentManager getDeploymentManager() {
        return this.deployMgr;
    }

    public void setDeploymentManager(DeploymentManager deployMgr) {
        this.deployMgr = deployMgr;
    }

    @Override
    public Profile newProfile(ProfileKey key) throws Exception {
        DeploymentRepository repo = this.profileRepository.createProfileDeploymentRepository(key);
        return new ProfileImpl(repo, key);
    }

    @Override
    public void removeProfile(ProfileKey key) throws Exception, NoSuchProfileException {
        this.profileRepository.removeProfileDeploymentRepository(key);
    }
}

