/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profile.basic;

import java.io.IOException;

import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/**
 * Profile monitoring metadata changes.
 *
 * We need to cache files's last modifed timestamps,
 * since file.getChildren re-caches handlers,
 * hence hasBeenModified is useless.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class MetaDataAwareProfile extends ProfileImpl
{
   private MainDeployerStructure mainDeployer;
   private VirtualFileFilter filter;
   private StructureModificationChecker checker;

   public MetaDataAwareProfile(String profileRoot, ProfileKey key)
   {
      super(profileRoot, key);
   }

   /**
    * Set main deployer structure.
    *
    * @param mainDeployer the main deployer structure
    */
   @Deprecated
   public void setMainDeployer(MainDeployerStructure mainDeployer)
   {
      this.mainDeployer = mainDeployer;
   }

   /**
    * Set the metadata resources filter.
    *
    * @param filter the metadata resources filter
    */
   @Deprecated
   public void setFilter(VirtualFileFilter filter)
   {
      this.filter = filter;
   }

   protected StructureModificationChecker getChecker()
   {
      if (checker == null)
         throw new IllegalArgumentException("Null checker");

      return checker;
   }

   /**
    * Set the structure modification checker.
    *
    * @param checker the structure modification checker
    */
   public void setChecker(StructureModificationChecker checker)
   {
      this.checker = checker;
   }

   protected boolean hasBeenModified(VirtualFile root) throws Exception
   {
      return getChecker().hasStructureBeenModified(root);
   }

   /**
    * Has vfs deployment context been modified.
    *
    * @param deploymentContext the vfs deployment context
    * @return true if modified
    * @throws IOException for any error
    */
   @Deprecated
   protected boolean hasBeenModified(VFSDeploymentContext deploymentContext) throws IOException
   {
	   return getChecker().hasStructureBeenModified(deploymentContext);
   }

   // expecting all deployments from same context root
   // so path name should group them per deployment unit
   protected void postRemove(VFSDeployment deployment) throws Exception
   {
      getChecker().removeStructureRoot(deployment.getRoot());
   }

   /**
    * Get deployment context.
    *
    * @param name the deployment context name
    * @return vfs deployment context or null if doesn't exist or not vfs based
    */
   @SuppressWarnings("deprecation")
   @Deprecated
   protected VFSDeploymentContext getDeploymentContext(String name)
   {
      if (mainDeployer == null)
         throw new IllegalArgumentException("Null main deployer");

      DeploymentContext deploymentContext = mainDeployer.getDeploymentContext(name);
      if (deploymentContext == null || deploymentContext instanceof VFSDeploymentContext == false)
         return null;

      return (VFSDeploymentContext)deploymentContext;
   }
}
