/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.basic;

import java.io.IOException;

import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profile.basic.MetaDataAwareProfile;
import org.jboss.virtual.VirtualFileFilter;


/**
 * Profile service creating profiles that
 * monitor metadata changes.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class MetaDataAwareProfileService extends ProfileServiceImpl
{
   private MainDeployerStructure mainDeployer;
   private VirtualFileFilter filter;
   private StructureModificationChecker checker;

   public MetaDataAwareProfileService(String name) throws IOException
   {
      super(name);
   }

   protected Profile createProfile(ProfileKey key)
   {
      if (mainDeployer == null)
         throw new IllegalArgumentException("Null main deployer");

      MetaDataAwareProfile profile = new MetaDataAwareProfile(getProfileRoot(), key);
      profile.setDeploymentFilter(deploymentFilter);
      profile.setMainDeployer(mainDeployer);
      profile.setFilter(filter);
      profile.setChecker(checker);
      return profile;
   }

   /**
    * Set main deployer structure.
    *
    * @param mainDeployer the main deployer structure
    */
   @Deprecated
   public void setMainDeployer(MainDeployerStructure mainDeployer)
   {
      this.mainDeployer = mainDeployer;
   }

   /**
    * Set the metadata resources filter.
    *
    * @param filter the metadata resources filter
    */
   @Deprecated
   public void setFilter(VirtualFileFilter filter)
   {
      this.filter = filter;
   }

   /**
    * Set the structure modification checker.
    *
    * @param checker the structure modification checker
    */
   public void setChecker(StructureModificationChecker checker)
   {
      this.checker = checker;
   }
}