/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.persistence.xml;

import static org.jboss.system.server.profileservice.persistence.xml.PersistenceConstants.MANAGED_OBJECT_ELEMENT_NAME;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * A persisted xml representation of a ManagedObject.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
@JBossXmlSchema(
      xmlns = { @XmlNs(namespaceURI = "http://www.w3.org/2001/XMLSchema", prefix = "xs") },
      ignoreUnresolvedFieldOrClass=false,
      namespace = PersistenceConstants.NAMESPACE_1_0, 
      elementFormDefault = XmlNsForm.QUALIFIED,
      normalizeSpace=true)
@XmlRootElement(name = MANAGED_OBJECT_ELEMENT_NAME)
@XmlType(name = "managedObjectType", namespace = PersistenceConstants.NAMESPACE_1_0)
public class PersistedManagedObject extends AbstractMapSupport<PersistedProperty>
{
   /** The original name. */
   private String originalName;
   
   public PersistedManagedObject()
   {
      //
   }
   
   public PersistedManagedObject(String name)
   {
      super(name);
   }
   
   public PersistedManagedObject(String name, String className)
   {
      super(name, className);
   }
   
   @XmlAttribute(name = "original-name")
   public String getOriginalName()
   {
      return originalName;
   }
   
   public void setOriginalName(String originalName)
   {
      this.originalName = originalName;
   }
   
   @XmlElementWrapper(name="properties")
   @XmlElement(name = "property")
   public List<PersistedProperty> getProperties()
   {
      return new ArrayList(super.values());
   }
   
   public void setProperties(List<PersistedProperty> properties)
   {
      super.createMap(properties);
   }
   
   protected void toString(StringBuilder builder)
   {
      builder.append(", original-name = ").append(getOriginalName());
   }

}
