/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.Collections;
import java.util.Map;

import org.jboss.profileservice.spi.repository.Capability;

/**
 * Default Capability implementation
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 65457 $
 */
public class CapabilityImpl implements Capability
{
   private String name;
   private Map<String, Object> props;

   public CapabilityImpl(String name)
   {
      this(name, Collections.EMPTY_MAP);
   }
   public CapabilityImpl(String name, Map<String, Object> props)
   {
      this.name = name;
      this.props = props;
   }

   public String getName()
   {
      return name;
   }

   public Map<String, Object> getProperties()
   {
      return props;
   }
   public void setProperties(Map<String, Object> props)
   {
      this.props = props;
   }
   public Object addProperty(String name, Object value)
   {
      return props.put(name, value);
   }
}
