/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

import org.jboss.logging.Logger;

/**
 * Use the TCL to load a class on a CNFE as the ObjectInputStream
 * fails to use the TCL one would expect it to.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81032 $
 */
public class TCLObjectInputStream
   extends ObjectInputStream
{
   private static Logger log = Logger.getLogger(TCLObjectInputStream.class);
   private ClassLoader loader;

   public TCLObjectInputStream(InputStream in, ClassLoader loader)
      throws IOException
   {
      super(in);
      this.loader = loader;
   }

   @Override
   protected Class<?> resolveClass(ObjectStreamClass desc)
      throws IOException, ClassNotFoundException
   {
      String name = desc.getName();
      try
      {
         return super.resolveClass(desc);
      }
      catch(ClassNotFoundException e)
      {
         log.debug("ClassNotFoundException for name="+name+", retrying using TCL");
         return Class.forName(name, false, loader);
      }
   }

}
