/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.AbstractFileAttachmentsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSerializationAttachmentsSerializer
extends AbstractFileAttachmentsSerializer {
    private static final Logger log = Logger.getLogger(JavaSerializationAttachmentsSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws Exception {
        FileInputStream fis = new FileInputStream(attachmentsStore);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object object = null;
        try {
            object = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            URL[] path = JavaSerializationAttachmentsSerializer.getClassLoaderURLs(Thread.currentThread().getContextClassLoader());
            log.debug((Object)("ClassNotFoundException: " + e.getMessage() + ", path: " + Arrays.asList(path)));
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception igore) {}
            try {
                fis.close();
            }
            catch (Exception igore) {}
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveAttachment(File attachmentsStore, Object attachment) throws Exception {
        log.trace((Object)("saveAttachments, attachmentsStore=" + attachmentsStore + ", attachment=" + attachment));
        FileOutputStream fos = new FileOutputStream(attachmentsStore);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        try {
            oos.writeObject(attachment);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception igore) {}
            try {
                fos.close();
            }
            catch (Exception igore) {}
        }
    }

    private static URL[] getClassLoaderURLs(ClassLoader cl) {
        Object[] args;
        Method getURLs;
        Class<?> clClass;
        Class[] parameterTypes;
        Class<?> returnType;
        URL[] urls = new URL[]{};
        try {
            returnType = urls.getClass();
            parameterTypes = new Class[]{};
            clClass = cl.getClass();
            getURLs = clClass.getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (urls == null || urls.length == 0) {
            try {
                returnType = urls.getClass();
                parameterTypes = new Class[]{};
                clClass = cl.getClass();
                getURLs = clClass.getMethod("getAllURLs", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    args = new Object[]{};
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (urls == null || urls.length == 0) {
            try {
                returnType = urls.getClass();
                parameterTypes = new Class[]{};
                clClass = cl.getClass();
                getURLs = clClass.getMethod("getClasspath", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    args = new Object[]{};
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return urls;
    }
}

