/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.jmx;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXAdapter
implements ObjectFactory {
    private static Map<String, JMXConnector> jmxConnectorMap = new ConcurrentHashMap<String, JMXConnector>();

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj != null && obj instanceof Reference) {
            Reference ref = (Reference)obj;
            RefAddr urlRef = ref.get("JMXServiceURL");
            String url = (String)urlRef.getContent();
            JMXServiceURL jmxserviceURL = new JMXServiceURL(url);
            JMXConnector jmxc = null;
            jmxc = jmxConnectorMap.get(url);
            if (jmxc != null) {
                try {
                    jmxc.getConnectionId();
                }
                catch (IOException e) {
                    JMXAdapter.close(jmxc);
                    jmxc = null;
                }
            }
            if (jmxc == null) {
                jmxc = JMXConnectorFactory.connect(jmxserviceURL, new HashMap());
                jmxConnectorMap.put(url, jmxc);
            }
            return jmxc.getMBeanServerConnection();
        }
        return null;
    }

    public static void closeAll() {
        Set<String> keys = jmxConnectorMap.keySet();
        Collection<JMXConnector> values = jmxConnectorMap.values();
        for (JMXConnector c : values) {
            JMXAdapter.close(c);
        }
        for (String key : keys) {
            jmxConnectorMap.remove(key);
        }
    }

    private static void close(JMXConnector jmxc) {
        try {
            jmxc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

