/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.bootstrap;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileMetaData;
import org.jboss.profileservice.profile.metadata.plugin.FarmingProfileMetaData;
import org.jboss.profileservice.profile.metadata.plugin.PropertyProfileSourceMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.system.server.profileservice.bootstrap.StaticBootstrapProfileFactory;
import org.jboss.system.server.profileservice.repository.clustered.metadata.ClusteredProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.clustered.metadata.HotDeploymentClusteredProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.clustered.metadata.ImmutableClusteredProfileSourceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticClusteredProfileFactory
extends StaticBootstrapProfileFactory {
    private static final String HASINGLETON_NAME = "deploy-hasingleton";
    private static final String FARM_NAME = "farm";
    private List<URI> hasingletonURIs;
    private List<URI> farmURIs;

    public List<URI> getHASingletonURIs() {
        return this.hasingletonURIs;
    }

    public void setHASingletonURIs(List<URI> hasingletonURIs) {
        this.hasingletonURIs = hasingletonURIs;
    }

    public List<URI> getFarmURIs() {
        return this.farmURIs;
    }

    public void setFarmURIs(List<URI> farmURIs) {
        this.farmURIs = farmURIs;
    }

    @Override
    protected void createApplicationProfiles(List<ProfileMetaData> profiles, List<String> dependencies) {
        super.createApplicationProfiles(profiles, dependencies);
        ProfileMetaData farm = null;
        if (this.getFarmURIs() != null) {
            URI[] farmURIs = this.getFarmURIs().toArray(new URI[this.getFarmURIs().size()]);
            farm = this.createFarmingProfileMetaData(FARM_NAME, true, farmURIs, dependencies);
            profiles.add(farm);
            dependencies.add(FARM_NAME);
        }
        if (this.getHASingletonURIs() != null && !this.getHASingletonURIs().isEmpty()) {
            if (this.getHASingletonURIs().size() != 1) {
                // empty if block
            }
            URI hasingletonURI = this.getHASingletonURIs().get(0);
            ProfileMetaData hasingletons = this.createScanningProfile(HASINGLETON_NAME, hasingletonURI, Collections.EMPTY_SET, true);
            profiles.add(hasingletons);
            dependencies.add(HASINGLETON_NAME);
        }
    }

    private ProfileMetaData createFarmingProfileMetaData(String name, boolean hotDeployment, URI[] uris, Collection<String> subProfiles) {
        FarmingProfileMetaData farming = new FarmingProfileMetaData();
        farming.setName(name);
        farming.setSource((PropertyProfileSourceMetaData)this.createClusteredSource(uris, hotDeployment));
        if (hotDeployment) {
            farming.setScanPeriod(this.getScanPeriod());
        }
        this.processDependencies((AbstractProfileMetaData)farming, subProfiles);
        return farming;
    }

    protected ClusteredProfileSourceMetaData createClusteredSource(URI[] uris, boolean hotDeployment) {
        ClusteredProfileSourceMetaData source = null;
        source = hotDeployment ? new HotDeploymentClusteredProfileSourceMetaData() : new ImmutableClusteredProfileSourceMetaData();
        ArrayList<String> sources = new ArrayList<String>();
        for (URI uri : uris) {
            sources.add(uri.toString());
        }
        source.setSources(sources);
        return source;
    }
}

