/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.hotdeploy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ActionController;
import org.jboss.profileservice.spi.action.EventBus;
import org.jboss.profileservice.spi.action.ModificationEvent;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.managed.ManagedProfileDeployer;
import org.jboss.system.server.profileservice.hotdeploy.Scanner;

public class HDScanner
implements Runnable,
Scanner {
    private static final Logger log = Logger.getLogger(HDScanner.class);
    private ActionController actionController;
    private ScheduledExecutorService scanExecutor;
    private ScheduledFuture activeScan;
    private boolean createdScanExecutor;
    private String scanThreadName = "HDScanner";
    private long scanPeriod = 5000L;
    private int scanCount;
    private boolean suspended;
    private boolean scanEnabled = true;

    public ActionController getActionController() {
        return this.actionController;
    }

    public void setActionController(ActionController actionController) {
        this.actionController = actionController;
    }

    public ScheduledExecutorService getScanExecutor() {
        return this.scanExecutor;
    }

    public void setScanExecutor(ScheduledExecutorService scanExecutor) {
        this.scanExecutor = scanExecutor;
        this.createdScanExecutor = false;
    }

    public String getScanThreadName() {
        return this.scanThreadName;
    }

    public void setScanThreadName(String scanThreadName) {
        this.scanThreadName = scanThreadName;
    }

    public long getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(long period) {
        this.scanPeriod = period;
    }

    public boolean isScanScheduled() {
        return this.activeScan != null;
    }

    public boolean isScanEnabled() {
        return this.scanEnabled;
    }

    public synchronized int getScanCount() {
        return this.scanCount;
    }

    public synchronized void resetScanCount() {
        this.scanCount = 0;
    }

    public synchronized void setScanEnabled(boolean enabled) {
        this.scanEnabled = enabled;
        if (enabled && this.activeScan == null && this.scanExecutor != null) {
            this.start();
        } else if (!enabled && this.activeScan != null) {
            this.stop();
        }
    }

    public boolean isCreatedScanExecutor() {
        return this.createdScanExecutor;
    }

    public void create() throws Exception {
        if (this.scanExecutor == null) {
            this.scanExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, HDScanner.this.getScanThreadName());
                }
            });
            this.createdScanExecutor = true;
        }
    }

    public void start() {
        if (this.scanEnabled) {
            this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    public void destroy() {
        if (this.scanExecutor != null && this.createdScanExecutor) {
            try {
                this.scanExecutor.shutdownNow();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to cleanly shutdown scanExecutor", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.scan();
        }
        catch (Throwable e) {
            log.warn((Object)"Scan failed", e);
        }
        finally {
            this.incScanCount();
        }
    }

    public synchronized void suspend() {
        boolean bl = this.suspended = this.activeScan != null;
        if (this.suspended) {
            this.activeScan.cancel(false);
            try {
                this.activeScan.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.activeScan = null;
        }
    }

    public synchronized void resume() {
        if (this.suspended) {
            this.start();
        }
        this.suspended = false;
    }

    public synchronized void scan() throws Exception {
        List activeProfiles;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Begin deployment scan");
        }
        if ((activeProfiles = this.actionController.getActiveProfiles()) == null || activeProfiles.isEmpty()) {
            if (trace) {
                log.trace((Object)"End deployment scan, no active profiles");
            }
            return;
        }
        for (ProfileKey key : activeProfiles) {
            ManagedProfile managed = this.actionController.getManagedProfile(key);
            if (managed != null && !managed.getProfile().isMutable()) {
                if (!trace) continue;
                log.trace((Object)("Ignoring not mutable profile: " + key));
                continue;
            }
            MutableProfile activeProfile = (MutableProfile)MutableProfile.class.cast(managed.getProfile());
            ManagedProfileDeployer deployer = managed.getManagedDeployer();
            Collection modifiedDeployments = activeProfile.getModifiedDeployments();
            ArrayList<String> checkNames = new ArrayList<String>();
            for (ModificationInfo info : modifiedDeployments) {
                ProfileDeployment ctx = info.getDeployment();
                try {
                    switch (info.getStatus()) {
                        case ADDED: 
                        case MODIFIED: {
                            deployer.addDeployment(ctx);
                            checkNames.add(ctx.getName());
                            break;
                        }
                        case REMOVED: {
                            deployer.removeDeployment(ctx);
                        }
                    }
                }
                catch (DeploymentException e) {
                    log.warn((Object)("Failed to add deployment: " + ctx.getName()), (Throwable)e);
                }
            }
            try {
                if (modifiedDeployments.isEmpty()) continue;
                log.info((Object)modifiedDeployments);
                deployer.process();
                this.getEventBus().fireModificationEvent((ModificationEvent)new ProfileModificationEvent(ProfileModificationType.UPDATE, key));
                if (checkNames.isEmpty()) continue;
                deployer.checkComplete(checkNames.toArray(new String[checkNames.size()]));
            }
            catch (Exception e) {
                log.warn((Object)"Failed to process changes", (Throwable)e);
                return;
            }
        }
        if (trace) {
            log.trace((Object)"End deployment scan");
        }
    }

    EventBus getEventBus() {
        return (EventBus)EventBus.class.cast(this.actionController);
    }

    protected synchronized void incScanCount() {
        ++this.scanCount;
        this.notifyAll();
    }
}

