/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.tools;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.profileservice.deployment.hotdeploy.HDScannerFactory;
import org.jboss.profileservice.deployment.hotdeploy.Scanner;
import org.jboss.system.tools.DeploymentRepositoryAdapter;
import org.jboss.system.tools.ProfileServiceToolsFacade;

public class LegacyDeploymentScannerAdapter
extends ProfileServiceToolsFacade
implements DeploymentRepositoryAdapter {
    private HDScannerFactory hdFactory;
    private List<Scanner> stoppedScanners = new ArrayList<Scanner>();

    public HDScannerFactory getHdFactory() {
        return this.hdFactory;
    }

    public void setHdFactory(HDScannerFactory hdFactory) {
        this.hdFactory = hdFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        List<Scanner> list = this.stoppedScanners;
        synchronized (list) {
            Iterator<Scanner> scanners = this.stoppedScanners.iterator();
            while (scanners.hasNext()) {
                Scanner scanner = scanners.next();
                try {
                    scanner.start();
                }
                catch (Exception e) {}
                continue;
                finally {
                    scanners.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        List<Scanner> list = this.stoppedScanners;
        synchronized (list) {
            for (Scanner scanner : this.hdFactory.getRegisteredScanners()) {
                if (!scanner.isScheduled()) continue;
                try {
                    scanner.scan();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        List<Scanner> list = this.stoppedScanners;
        synchronized (list) {
            for (Scanner scanner : this.hdFactory.getRegisteredScanners()) {
                if (!scanner.isScheduled()) continue;
                scanner.stop();
                this.stoppedScanners.add(scanner);
            }
        }
    }

    public void addURL(URL url) throws URISyntaxException {
        super.addURI(url.toURI());
    }

    public boolean hasURL(URL url) throws URISyntaxException {
        return super.managesURI(url.toURI());
    }

    public void removeURL(URL url) throws URISyntaxException {
        super.removeURI(url.toURI());
    }
}

