/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.servermanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.jbossas.servermanager.ServerManager;
import org.jboss.jbossas.servermanager.ServerShutdownException;

public abstract class ServerController {
    private static final String MAIN = "org.jboss.Main";

    private ServerController() {
    }

    public static void startServer(Server server, ServerManager manager) throws IOException {
        if (server.isRunning()) {
            throw new IllegalArgumentException("The " + server.getName() + " server is already running.");
        }
        if (ServerController.isServerStarted(server)) {
            throw new IOException("Found a process already listening on:" + server.getHttpUrl() + " or " + server.getRmiUrl());
        }
        server.setNamingContext(null);
        server.setServerConnection(null);
        String execCmd = ServerController.getStartCommandLine(server, manager);
        System.out.println("Starting server \"" + server.getName() + "\", with command (start timeout is " + manager.getStartupTimeout() + " seconds ): \n" + execCmd);
        File binDir = new File(manager.getJBossHome(), "/bin");
        Process process = Runtime.getRuntime().exec(execCmd, null, binDir);
        BufferedReader errStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        BufferedReader inStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
        File outFile = server.getOutputLog();
        ServerController.initalizeLog(outFile);
        PrintWriter outlog = new PrintWriter(new FileWriter(outFile));
        server.setOutWriter(outlog);
        OutputPumper outPump = new OutputPumper(inStream, outlog);
        outPump.start();
        File errorFile = server.getErrorLog();
        ServerController.initalizeLog(errorFile);
        PrintWriter errorlog = new PrintWriter(new FileWriter(errorFile));
        server.setErrorWriter(errorlog);
        OutputPumper errorPump = new OutputPumper(errStream, errorlog);
        errorPump.start();
        server.setProcess(process);
        try {
            ServerController.waitForServer(server, manager);
        }
        catch (IOException e) {
            server.setProcess(null);
            throw e;
        }
    }

    private static void initalizeLog(File logFile) throws IOException {
        if (logFile.exists()) {
            logFile.delete();
        }
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdir();
        }
        logFile.createNewFile();
    }

    private static String getStartCommandLine(Server server, ServerManager manager) throws IOException {
        String execCmd = manager.getJavaExecutable() + " -cp " + manager.getStartClasspath() + " ";
        execCmd = execCmd + server.getJvmArgs() + server.getSysProperties();
        execCmd = execCmd + " " + MAIN + " -c " + server.getConfig() + " -b " + server.getHost() + " -g " + server.getPartition();
        if (manager.getUdpGroup() != null && !manager.getUdpGroup().equals("")) {
            execCmd = execCmd + " -u " + manager.getUdpGroup();
        }
        execCmd = execCmd + " " + server.getArgs();
        return execCmd;
    }

    private static void waitForServer(Server server, ServerManager manager) throws IOException {
        int tries = 0;
        while (tries++ < manager.getStartupTimeout()) {
            if (!server.isRunning()) {
                throw new IOException("Server failed to start; see logs. exit code: " + server.getProcess().exitValue());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!ServerController.isServerStarted(server)) continue;
            return;
        }
        Process process = server.getProcess();
        System.err.println("Failed to start server \"" + server.getName() + "\" before timeout. Destroying the process.");
        process.destroy();
        throw new IOException("Server failed to start in time; see logs.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerStarted(Server server) throws IOException {
        URL url = server.getHttpUrl();
        if (server.hasWebServer()) {
            try {
                HttpURLConnection http;
                int responseCode;
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpURLConnection && (responseCode = (http = (HttpURLConnection)conn).getResponseCode()) > 0 && responseCode < 400) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
            return false;
        }
        Socket socket = null;
        try {
            socket = new Socket(server.getHost(), (int)server.getRmiPort());
            boolean http = true;
            return http;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static void stopServer(Server server, ServerManager manager) throws IOException {
        boolean cleanShutdown = true;
        Throwable shutdownException = null;
        if (!server.isRunning()) {
            throw new IllegalArgumentException("The " + server.getName() + " is not running; it cannot be stopped.");
        }
        System.out.println("Shutting down server: " + server.getName());
        try {
            server.doShutdown();
        }
        catch (Throwable e) {
            shutdownException = e;
            cleanShutdown = false;
        }
        Process process = server.getProcess();
        if (cleanShutdown && !ServerController.waitOnShutdown(server, manager)) {
            cleanShutdown = false;
        }
        if (!cleanShutdown) {
            try {
                ServerController.writeServerDump(server);
            }
            catch (Throwable e) {
                System.err.println("Cannot write to " + server.getDumpFile().getAbsolutePath());
                e.printStackTrace();
            }
            process.destroy();
            System.err.println("Failed to shutdown server \"" + server.getName() + "\"" + (shutdownException == null ? " before timeout." : ".") + " Destroying the process.");
        }
        ServerController.closeAllStreams(process);
        server.getErrorWriter().close();
        server.getOutWriter().close();
        server.setProcess(null);
        try {
            Thread.sleep(45000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!cleanShutdown) {
            throw (ServerShutdownException)new ServerShutdownException("Failed to shutdown server" + (shutdownException == null ? " before timeout." : ".") + "Process was destroyed.").initCause(shutdownException);
        }
    }

    private static void writeServerDump(Server server) throws IOException {
        String threadDump = null;
        Exception dumpException = null;
        try {
            threadDump = server.listThreadDump();
        }
        catch (Exception e) {
            dumpException = e;
        }
        if (threadDump == null) {
            threadDump = "Unable to get server thread dump: ";
            if (dumpException == null) {
                dumpException = (Exception)new RuntimeException("threadDump and dumpException null - something broken").fillInStackTrace();
            }
            StringWriter dumpExceptionWriter = new StringWriter(512);
            dumpException.printStackTrace(new PrintWriter(dumpExceptionWriter));
            threadDump = threadDump + dumpExceptionWriter.toString();
        }
        File dumpFile = server.getDumpFile();
        System.out.println("Writing server thread dump to " + dumpFile.getAbsolutePath());
        FileWriter dumpFW = new FileWriter(dumpFile);
        dumpFW.write(threadDump);
        dumpFW.flush();
        dumpFW.close();
    }

    private static boolean waitOnShutdown(Server server, ServerManager manager) {
        int shutdownTimeout = manager.getShutdownTimeout();
        System.out.println("shutdownTimeout will be=" + shutdownTimeout);
        for (int tries = 0; tries < shutdownTimeout; ++tries) {
            try {
                if (!server.isRunning()) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static void closeAllStreams(Process process) {
        try {
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class OutputPumper
    extends Thread {
        private BufferedReader outputReader;
        private PrintWriter logWriter;

        public OutputPumper(BufferedReader outputReader, PrintWriter logWriter) {
            this.outputReader = outputReader;
            this.logWriter = logWriter;
        }

        public void run() {
            try {
                String line = null;
                while ((line = this.outputReader.readLine()) != null) {
                    this.logWriter.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

