/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.jboss.jms.client.container.ConnectionFailureListener;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;

public class ConsolidatedRemotingConnectionListener
implements ConnectionListener {
    private static final Logger log = Logger.getLogger(ConsolidatedRemotingConnectionListener.class);
    private ConnectionState state;
    private ExceptionListener jmsExceptionListener;
    private ConnectionFailureListener remotingListener;
    private boolean started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnectionException(Throwable throwable, Client client) {
        ConnectionFailureListener remotingListenerCopy;
        ExceptionListener jmsExceptionListenerCopy;
        if (!this.started) {
            return;
        }
        ConsolidatedRemotingConnectionListener consolidatedRemotingConnectionListener = this;
        synchronized (consolidatedRemotingConnectionListener) {
            jmsExceptionListenerCopy = this.jmsExceptionListener;
            remotingListenerCopy = this.remotingListener;
        }
        boolean forwardToJMSListener = true;
        if (remotingListenerCopy != null) {
            try {
                log.trace((Object)(this + " forwarding remoting failure \"" + throwable + "\" to " + remotingListenerCopy));
                forwardToJMSListener = !remotingListenerCopy.handleConnectionException(throwable, client);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to forward " + throwable + " to " + remotingListenerCopy), (Throwable)e);
            }
        }
        if (forwardToJMSListener && jmsExceptionListenerCopy != null) {
            JMSException jmsException = null;
            if (throwable instanceof Error) {
                String msg = "Caught Error on underlying remoting connection";
                log.error((Object)(this + ": " + "Caught Error on underlying remoting connection"), throwable);
                jmsException = new JMSException("Caught Error on underlying remoting connection: " + throwable.getMessage());
            } else if (throwable instanceof Exception) {
                Exception e = (Exception)throwable;
                jmsException = new JMSException("Failure on underlying remoting connection");
                jmsException.setLinkedException(e);
            } else {
                String msg = "Caught Throwable on underlying remoting connection";
                log.error((Object)(this + ": " + "Caught Throwable on underlying remoting connection"), throwable);
                jmsException = new JMSException("Caught Throwable on underlying remoting connection: " + throwable.getMessage());
            }
            jmsExceptionListenerCopy.onException(jmsException);
        }
    }

    public synchronized void setDelegateListener(ConnectionFailureListener l) {
        log.trace((Object)(this + " setting delegate listener " + l));
        if (this.remotingListener != null) {
            throw new IllegalStateException("There is already a connection listener for the connection");
        }
        this.remotingListener = l;
    }

    public synchronized void addJMSExceptionListener(ExceptionListener jmsExceptionListener) {
        log.trace((Object)(this + " adding JMS exception listener " + jmsExceptionListener));
        this.jmsExceptionListener = jmsExceptionListener;
    }

    public synchronized ExceptionListener getJMSExceptionListener() {
        return this.jmsExceptionListener;
    }

    public synchronized void clear() {
        this.jmsExceptionListener = null;
        this.remotingListener = null;
        log.trace((Object)(this + " cleared"));
    }

    public void setConnectionState(ConnectionState state) {
        this.state = state;
    }

    public String toString() {
        if (this.state == null) {
            return "ConsolidatedListener(UNINITIALIZED)";
        }
        return this.state + ".ConsolidatedListener";
    }

    public void start() {
        this.started = true;
    }
}

