/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.web.jboss;

import org.jboss.metadata.javaee.support.IdMetaDataImpl;

/**
 * Represents a <passivation-config> element of the jboss-web.xml 
 * deployment descriptor 
 * 
 * @author Brian Stansberry
 * @version <tt>$Revision: 67676 $</tt>
 */
public class PassivationConfig extends IdMetaDataImpl
{  
   /** The serialVersionUID */
   private static final long serialVersionUID = 1;

   private Boolean useSessionPassivation;
   
   private Integer passivationMinIdleTime;
   
   private Integer passivationMaxIdleTime;
   
   private Integer maxObjects;
   
   private Integer objectMaxIdleTime;

   /**
    * Gets the max time (seconds) the session must be idle after which it's 
    * eligible for passivation whether or not maxActiveSessions has been reached.
    */
   public Integer getPassivationMaxIdleTime()
   {
      return passivationMaxIdleTime;
   }

   /**
    * Sets the max time (seconds) the session must be idle after which it's 
    * eligible for passivation whether or not maxActiveSessions has been reached.
    */
   public void setPassivationMaxIdleTime(Integer passivationMaxIdleTime)
   {
      this.passivationMaxIdleTime = passivationMaxIdleTime;
   }

   /**
    * Gets the min time (seconds) a session must be idle before it's eligible for passivation.
    * This overrides the maxActiveSessions config, to prevent thrashing if the there are lots of active sessions.
    * Setting to -1 means it's ignored
    */
   public Integer getPassivationMinIdleTime()
   {
      return passivationMinIdleTime;
   }

   /**
    * Sets the min time (seconds) a session must be idle before it's eligible for passivation.
    * This overrides the maxActiveSessions config, to prevent thrashing if the there are lots of active sessions.
    * Setting to -1 means it's ignored
    */
   public void setPassivationMinIdleTime(Integer passivationMinIdleTime)
   {
      this.passivationMinIdleTime = passivationMinIdleTime;
   }

   /**
    * Gets whether passivation is enabled for this webapp.
    */
   public Boolean getUseSessionPassivation()
   {
      return useSessionPassivation;
   }

   /**
    * Sets whether passivation is enabled for this webapp.
    */
   public void setUseSessionPassivation(Boolean useSessionPassivation)
   {
      this.useSessionPassivation = useSessionPassivation;
   }

   /**
    * Gets the maximum number of cached {@link ReplicationGranularity.FIELD} 
    * session attribute objects before the session management 
    * layer should begin passivating them to persistent storage.
    * 
    * @return the maximum number of objects, or <code>null</code>
    */
   public Integer getMaxObjects()
   {
      return maxObjects;
   }

   /**
    * Sets the maximum number of cached {@link ReplicationGranularity.FIELD} 
    * session attribute objects before the session management 
    * layer should begin passivating them to persistent storage.
    * 
    * @param maxObjects the maximum number of objects. Note that if a complex 
    *                   object graph is passed to setAttribute(), the number of 
    *                   cached objects is increased by the number of objects in 
    *                   the graph, not by 1. Primitive objects 
    *                   (i.e. java.lang.String, java.lang.Number) included 
    *                   within a complex object graph do not increase the total.
    *                   If set to <code>null</code> or a value less than one,
    *                   the number of objects is not considered. 
    */
   public void setMaxObjects(Integer maxObjects)
   {
      this.maxObjects = maxObjects;
   }

   /**
    * Gets the maximum time (in seconds) cached 
    * {@link ReplicationGranularity.FIELD} session 
    * attribute objects can remain unaccessed before the session management 
    * layer should begin passivating them to persistent storage.  Only
    * relevant if {@link ReplicationGranularity.FIELD} is used.
    * 
    * @return the maximum idle time, or <code>null</code>. A value less than
    *         <code>1</code> means object idle time should not be considered.
    */
   public Integer getObjectMaxIdleTime()
   {
      return objectMaxIdleTime;
   }

   /**
    * Sets the maximum time (in seconds) cached 
    * {@link ReplicationGranularity.FIELD} session 
    * attribute objects can remain unaccessed before the session management 
    * layer should begin passivating them to persistent storage.  Only
    * relevant if {@link ReplicationGranularity.FIELD} is used.
    * 
    * @param objectIdleTime the maximum idle time. A value of <code>null</code> 
    *                       or less than <code>1</code> means object idle time 
    *                       should not be considered.
    */
   public void setObjectMaxIdleTime(Integer objectMaxIdleTime)
   {
      this.objectMaxIdleTime = objectMaxIdleTime;
   }
   
   
   
}
