/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndipolicy.plugins;

import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;

public class BasicJndiBindingPolicy
implements DefaultJndiBindingPolicy {
    private String baseJndiName;

    public BasicJndiBindingPolicy() {
    }

    public BasicJndiBindingPolicy(String baseJndiName) {
        this.baseJndiName = baseJndiName;
    }

    public String getBaseJndiName() {
        return this.baseJndiName;
    }

    public void setBaseJndiName(String baseJndiName) {
        this.baseJndiName = baseJndiName;
    }

    public String getDefaultLocalHomeJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "localHome";
    }

    public String getDefaultLocalJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "local";
    }

    public String getDefaultRemoteHomeJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "remoteHome";
    }

    public String getDefaultRemoteJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "remote";
    }

    public String getJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName;
    }

    public String getJndiName(EjbDeploymentSummary summary, String iface, KnownInterfaces.KnownInterfaceType ifaceType) {
        String jndiName = null;
        if (KnownInterfaces.isKnownInterface(iface)) {
            iface = null;
        }
        if (ifaceType == KnownInterfaces.KnownInterfaceType.UNKNOWN) {
            jndiName = iface == null ? this.baseJndiName : this.baseJndiName + "/" + iface;
        } else {
            boolean is3x = summary.getBeanMD().getJBossMetaData().isEJB3x();
            switch (ifaceType) {
                case BUSINESS_LOCAL: 
                case BUSINESS_REMOTE: 
                case UNKNOWN: {
                    if (iface == null) {
                        jndiName = this.baseJndiName + "/" + ifaceType.toSuffix();
                        break;
                    }
                    jndiName = this.baseJndiName + "/" + ifaceType.toSuffix() + "-" + iface;
                    break;
                }
                case LOCAL_HOME: {
                    if (is3x) {
                        jndiName = this.baseJndiName + "/" + ifaceType.toSuffix();
                        break;
                    }
                    jndiName = summary.getBeanMD().determineLocalJndiName();
                    break;
                }
                case REMOTE_HOME: {
                    jndiName = is3x ? this.baseJndiName + "/" + ifaceType.toSuffix() : this.baseJndiName;
                }
            }
        }
        return jndiName;
    }
}

