/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.spec;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="security-roleType")
public class SecurityRoleMetaData
extends NamedMetaDataWithDescriptions
implements MergeableMappedMetaData<SecurityRoleMetaData> {
    private static final long serialVersionUID = -4349954695900237831L;
    private Set<String> principals;

    public String getRoleName() {
        return this.getName();
    }

    public void setRoleName(String roleName) {
        this.setName(roleName);
    }

    public Set<String> getPrincipals() {
        return this.principals;
    }

    @XmlElement(name="principal-name", required=false)
    public void setPrincipals(Set<String> principals) {
        if (principals == null) {
            throw new IllegalArgumentException("Null principals");
        }
        this.principals = principals;
    }

    public boolean hasPrincipal(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("Null userName");
        }
        if (this.principals == null) {
            return false;
        }
        return this.principals.contains(userName);
    }

    @Override
    public SecurityRoleMetaData merge(SecurityRoleMetaData original) {
        SecurityRoleMetaData merged = new SecurityRoleMetaData();
        merged.merge(this, original);
        return merged;
    }

    public void merge(SecurityRoleMetaData override, SecurityRoleMetaData original) {
        super.merge(override, original);
        if (override != null && override.principals != null) {
            if (this.principals == null) {
                this.principals = new HashSet<String>();
            }
            this.principals.addAll(override.principals);
        }
        if (original != null && original.principals != null) {
            if (this.principals == null) {
                this.principals = new HashSet<String>();
            }
            this.principals.addAll(original.principals);
        }
    }
}

