/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndipolicy.plugins;

import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;

public class BasicJndiBindingPolicy
implements DefaultJndiBindingPolicy {
    private String baseJndiName;

    public BasicJndiBindingPolicy() {
    }

    public BasicJndiBindingPolicy(String baseJndiName) {
        this.baseJndiName = baseJndiName;
    }

    public String getBaseJndiName() {
        return this.baseJndiName;
    }

    public void setBaseJndiName(String baseJndiName) {
        this.baseJndiName = baseJndiName;
    }

    public String getDefaultLocalHomeJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "localHome";
    }

    public String getDefaultLocalJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "local";
    }

    public String getDefaultRemoteHomeJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "home";
    }

    public String getDefaultRemoteJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "remote";
    }

    public String getJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName;
    }

    public String getJndiName(EjbDeploymentSummary summary, String iface, KnownInterfaces.KnownInterfaceType ifaceType) {
        String jndiName = null;
        if (KnownInterfaces.isKnownInterface(iface)) {
            iface = null;
        }
        if (ifaceType == KnownInterfaces.KnownInterfaceType.UNKNOWN) {
            jndiName = iface == null ? this.baseJndiName : this.baseJndiName + "/" + iface;
        } else {
            boolean is3x = summary.getBeanMD().getJBossMetaData().isEJB3x();
            if (is3x) {
                switch (ifaceType) {
                    case BUSINESS_LOCAL: 
                    case BUSINESS_REMOTE: 
                    case UNKNOWN: {
                        if (iface == null) {
                            jndiName = this.baseJndiName + "/" + ifaceType.toSuffix();
                            break;
                        }
                        jndiName = this.baseJndiName + "/" + ifaceType.toSuffix() + "-" + iface;
                        break;
                    }
                    case LOCAL_HOME: {
                        jndiName = this.baseJndiName + "/" + ifaceType.toSuffix();
                        break;
                    }
                    case REMOTE_HOME: {
                        jndiName = this.baseJndiName + "/" + ifaceType.toSuffix();
                    }
                }
            } else {
                switch (ifaceType) {
                    case BUSINESS_LOCAL: 
                    case LOCAL_HOME: {
                        jndiName = summary.getBeanMD().determineLocalJndiName();
                        break;
                    }
                    case BUSINESS_REMOTE: 
                    case REMOTE_HOME: {
                        jndiName = this.baseJndiName;
                    }
                }
            }
        }
        return jndiName;
    }
}

