/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.ejb.jboss;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 * @author <a href="mailto:carlo.dewolf@jboss.com">Carlo de Wolf</a>
 * @version <tt>$Revision: 74039 $</tt>
 */
@XmlType(name="message-propertiesType")
public class MessagePropertiesMetaData
{
   private MethodAttributeMetaData method;
   private String delivery;
   private Integer priority;
   private String className;

   public MethodAttributeMetaData getMethod()
   {
      return method;
   }
   
   public void setMethod(MethodAttributeMetaData method)
   {
      this.method = method;
   }
   
   public String getDelivery()
   {
      return delivery;
   }
   
   public void setDelivery(String delivery)
   {
      this.delivery = delivery;
   }
   
   @XmlElement(name="class")
   public String getClassName()
   {
      return className;
   }
   
   public void setClassName(String className)
   {
      this.className = className;
   }
   
   public Integer getPriority()
   {
      return priority;
   }
   
   public void setPriority(Integer priority)
   {
      this.priority = priority;
   }

   public String toString()
   {
      StringBuffer sb = new StringBuffer(100);
      sb.append("[");
      sb.append("className=").append(className);
      sb.append(", priority=").append(priority);
      sb.append(", delivery=").append(delivery);
      sb.append(", method=").append(method);
      sb.append("]");
      return sb.toString();
   }
}
