/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.ejb.IEjbJarMetaData;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaData;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationsMetaData;
import org.jboss.metadata.ejb.jboss.InvokerProxyBindingMetaData;
import org.jboss.metadata.ejb.jboss.InvokerProxyBindingsMetaData;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.ResourceManagerMetaData;
import org.jboss.metadata.ejb.jboss.ResourceManagersMetaData;
import org.jboss.metadata.ejb.jboss.WebservicesMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DeploymentSummary;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.ejb.spec.RelationsMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossMetaData
extends IdMetaDataImplWithDescriptionGroup
implements IEjbJarMetaData<JBossAssemblyDescriptorMetaData, JBossEnterpriseBeansMetaData, JBossEnterpriseBeanMetaData, JBossMetaData> {
    private static final long serialVersionUID = 598759931857080298L;
    private static final Logger log = Logger.getLogger(JBossMetaData.class);
    private String dtdPublicId;
    private String dtdSystemId;
    private String version;
    private String ejbVersion;
    private String ejbClientJar;
    private RelationsMetaData relationships;
    private LoaderRepositoryMetaData loaderRepository;
    private String jmxName;
    private String securityDomain;
    private String jaccContextID;
    private boolean excludeMissingMethods = true;
    private String unauthenticatedPrincipal;
    private boolean exceptionOnRollback;
    private WebservicesMetaData webservices;
    private JBossEnterpriseBeansMetaData enterpriseBeans;
    private JBossAssemblyDescriptorMetaData assemblyDescriptor;
    private ResourceManagersMetaData resourceManagers;
    private InvokerProxyBindingsMetaData invokerProxyBindings;
    private ContainerConfigurationsMetaData containerConfigurations;
    private InterceptorsMetaData interceptors;
    private Map<String, RunAsIdentityMetaData> runAsIdentity = new HashMap<String, RunAsIdentityMetaData>();
    private boolean metadataComplete;
    private String jndiBindingPolicy;
    private DeploymentSummary deploymentSummary;

    @XmlTransient
    public void setDTD(String root, String publicId, String systemId) {
        this.dtdPublicId = publicId;
        this.dtdSystemId = systemId;
        if (this.dtdPublicId != null && this.dtdPublicId.contains("3.0")) {
            this.setVersion("3.0");
        }
        if (this.dtdPublicId != null && this.dtdPublicId.contains("3.2")) {
            this.setVersion("3.2");
        }
        if (this.dtdPublicId != null && this.dtdPublicId.contains("4.0")) {
            this.setVersion("4.0");
        }
        if (this.dtdPublicId != null && this.dtdPublicId.contains("4.2")) {
            this.setVersion("4.2");
        }
        if (this.dtdPublicId != null && this.dtdPublicId.contains("5.0")) {
            this.setVersion("5.0");
        }
    }

    @XmlTransient
    public String getDtdPublicId() {
        return this.dtdPublicId;
    }

    @XmlTransient
    public String getDtdSystemId() {
        return this.dtdSystemId;
    }

    @Override
    @XmlTransient
    public InterceptorsMetaData getInterceptors() {
        return this.interceptors;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    @XmlAttribute
    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        this.version = version;
    }

    @Override
    public JBossAssemblyDescriptorMetaData getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    @Override
    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    @Override
    public void setEjbClientJar(String ejbClientJar) {
        this.ejbClientJar = ejbClientJar;
    }

    @XmlTransient
    public String getEjbVersion() {
        return this.ejbVersion;
    }

    public void setEjbVersion(String ejbVersion) {
        this.ejbVersion = ejbVersion;
    }

    @Override
    public RelationsMetaData getRelationships() {
        return this.relationships;
    }

    @Override
    public void setRelationships(RelationsMetaData relationships) {
        this.relationships = relationships;
    }

    @Override
    public boolean isEJB1x() {
        return this.ejbVersion != null && this.ejbVersion.contains("1.");
    }

    @Override
    public boolean isEJB21() {
        return this.ejbVersion != null && this.ejbVersion.contains("2.1");
    }

    @Override
    public boolean isEJB2x() {
        return this.ejbVersion != null && this.ejbVersion.contains("2.");
    }

    @Override
    public boolean isEJB3x() {
        return this.ejbVersion != null && this.ejbVersion.contains("3.");
    }

    public LoaderRepositoryMetaData getLoaderRepository() {
        return this.loaderRepository;
    }

    public void setLoaderRepository(LoaderRepositoryMetaData loaderRepository) {
        if (loaderRepository == null) {
            throw new IllegalArgumentException("Null loaderRepository");
        }
        this.loaderRepository = loaderRepository;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public String getJaccContextID() {
        return this.jaccContextID;
    }

    public void setJmxName(String jmxName) {
        if (jmxName == null) {
            throw new IllegalArgumentException("Null jmxName");
        }
        this.jmxName = jmxName;
    }

    public void setJaccContextID(String jaccContextID) {
        this.jaccContextID = jaccContextID;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        if (securityDomain == null) {
            throw new IllegalArgumentException("Null securityDomain");
        }
        this.securityDomain = securityDomain.trim();
    }

    public boolean isExcludeMissingMethods() {
        return this.excludeMissingMethods;
    }

    @XmlElement(name="missing-method-permissions-excluded-mode")
    public void setExcludeMissingMethods(boolean excludeMissingMethods) {
        this.excludeMissingMethods = excludeMissingMethods;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public void setUnauthenticatedPrincipal(String unauthenticatedPrincipal) {
        if (unauthenticatedPrincipal == null) {
            throw new IllegalArgumentException("Null unauthenticatedPrincipal");
        }
        this.unauthenticatedPrincipal = unauthenticatedPrincipal;
    }

    public boolean isExceptionOnRollback() {
        return this.exceptionOnRollback;
    }

    public void setExceptionOnRollback(boolean exceptionOnRollback) {
        this.exceptionOnRollback = exceptionOnRollback;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    @Override
    public JBossEnterpriseBeansMetaData getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    @Override
    @XmlElement(name="enterprise-beans")
    public void setEnterpriseBeans(JBossEnterpriseBeansMetaData enterpriseBeans) {
        if (enterpriseBeans == null) {
            throw new IllegalArgumentException("Null enterpriseBeans");
        }
        this.enterpriseBeans = enterpriseBeans;
        this.enterpriseBeans.setJBossMetaData(this);
    }

    @Override
    public JBossEnterpriseBeanMetaData getEnterpriseBean(String name) {
        if (this.enterpriseBeans == null) {
            return null;
        }
        return (JBossEnterpriseBeanMetaData)this.enterpriseBeans.get(name);
    }

    public void setEnforceEjbRestrictions(String enforceEjbRestrictions) {
        log.warn((Object)"<enforce-ejb-restrictions/> in jboss.xml is no longer used and will be removed in a future version.");
    }

    public WebservicesMetaData getWebservices() {
        return this.webservices;
    }

    public void setWebservices(WebservicesMetaData webservices) {
        if (webservices == null) {
            throw new IllegalArgumentException("Null webservices");
        }
        this.webservices = webservices;
    }

    public ContainerConfigurationsMetaData getContainerConfigurations() {
        return this.containerConfigurations;
    }

    public void setContainerConfigurations(ContainerConfigurationsMetaData containerConfigurations) {
        if (containerConfigurations == null) {
            throw new IllegalArgumentException("Null containerConfigurations");
        }
        this.containerConfigurations = containerConfigurations;
    }

    public ContainerConfigurationMetaData getContainerConfiguration(String name) {
        if (this.containerConfigurations == null) {
            return null;
        }
        return (ContainerConfigurationMetaData)this.containerConfigurations.get(name);
    }

    public InvokerProxyBindingsMetaData getInvokerProxyBindings() {
        return this.invokerProxyBindings;
    }

    public void setInvokerProxyBindings(InvokerProxyBindingsMetaData invokerProxyBindings) {
        if (invokerProxyBindings == null) {
            throw new IllegalArgumentException("Null invokerProxyBindings");
        }
        this.invokerProxyBindings = invokerProxyBindings;
    }

    public InvokerProxyBindingMetaData getInvokerProxyBinding(String name) {
        if (this.invokerProxyBindings == null) {
            return null;
        }
        return (InvokerProxyBindingMetaData)this.invokerProxyBindings.get(name);
    }

    public ResourceManagersMetaData getResourceManagers() {
        return this.resourceManagers;
    }

    public void setResourceManagers(ResourceManagersMetaData resourceManagers) {
        if (resourceManagers == null) {
            throw new IllegalArgumentException("Null resourceManagers");
        }
        this.resourceManagers = resourceManagers;
    }

    public ResourceManagerMetaData getResourceManager(String name) {
        if (this.resourceManagers == null) {
            return null;
        }
        return (ResourceManagerMetaData)this.resourceManagers.get(name);
    }

    @Override
    public void setAssemblyDescriptor(JBossAssemblyDescriptorMetaData assemblyDescriptor) {
        if (assemblyDescriptor == null) {
            throw new IllegalArgumentException("Null assemblyDescriptor");
        }
        this.assemblyDescriptor = assemblyDescriptor;
    }

    public String getJndiBindingPolicy() {
        return this.jndiBindingPolicy;
    }

    public void setJndiBindingPolicy(String jndiBindingPolicy) {
        this.jndiBindingPolicy = jndiBindingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XmlTransient
    public RunAsIdentityMetaData getRunAsIdentity(String ejbName) {
        JBossEnterpriseBeanMetaData ejb;
        RunAsIdentityMetaData identity = this.runAsIdentity.get(ejbName);
        if (identity == null && (ejb = this.getEnterpriseBean(ejbName)) != null) {
            Map<String, RunAsIdentityMetaData> map = this.runAsIdentity;
            synchronized (map) {
                RunAsMetaData runAs;
                SecurityIdentityMetaData si = ejb.getSecurityIdentity();
                if (si != null && (runAs = si.getRunAs()) != null) {
                    String roleName = runAs.getRoleName();
                    identity = new RunAsIdentityMetaData(roleName, null);
                    this.runAsIdentity.put(ejbName, identity);
                }
            }
        }
        return identity;
    }

    @XmlTransient
    public DeploymentSummary getDeploymentSummary() {
        return this.deploymentSummary;
    }

    public void setDeploymentSummary(DeploymentSummary deploymentSummary) {
        this.deploymentSummary = deploymentSummary;
    }

    public void merge(JBossMetaData override, EjbJarMetaData original) {
        super.merge(override, original);
        if (override != null && override.getVersion() != null) {
            this.version = override.getVersion();
        } else if (original != null && original.getVersion() != null) {
            this.version = original.getVersion();
        }
        if (this.assemblyDescriptor == null) {
            this.assemblyDescriptor = new JBossAssemblyDescriptorMetaData();
        }
        if (this.resourceManagers == null) {
            this.resourceManagers = new ResourceManagersMetaData();
        }
        if (this.containerConfigurations == null) {
            this.containerConfigurations = new ContainerConfigurationsMetaData();
        }
        if (override != null && override.containerConfigurations != null) {
            this.containerConfigurations.merge(override.containerConfigurations);
        }
        if (this.invokerProxyBindings == null) {
            this.invokerProxyBindings = new InvokerProxyBindingsMetaData();
        }
        if (override != null && override.invokerProxyBindings != null) {
            this.invokerProxyBindings.merge(override.invokerProxyBindings);
        }
        if (this.interceptors == null) {
            this.interceptors = new InterceptorsMetaData();
        }
        if (override != null && override.webservices != null) {
            this.webservices = new WebservicesMetaData();
        }
        if (original != null) {
            this.ejbVersion = original.getVersion();
            this.relationships = original.getRelationships();
            if (original instanceof EjbJar3xMetaData) {
                EjbJar3xMetaData original3x = (EjbJar3xMetaData)original;
                this.metadataComplete = original3x.isMetadataComplete();
            }
        }
        if (override != null && override.assemblyDescriptor != null) {
            this.assemblyDescriptor.merge(override.assemblyDescriptor, original.getAssemblyDescriptor());
        } else if (original != null && original.getAssemblyDescriptor() != null) {
            this.assemblyDescriptor.merge(null, original.getAssemblyDescriptor());
        }
        if (override != null && override.resourceManagers != null) {
            this.resourceManagers.merge(override.resourceManagers);
        }
        if (override != null && override.interceptors != null) {
            this.interceptors.merge(override.interceptors);
        } else if (original != null && original.getInterceptors() != null) {
            this.interceptors.merge(original.getInterceptors());
        }
        if (override != null) {
            if (override.jaccContextID != null) {
                this.jaccContextID = override.jaccContextID;
            }
            if (override.jmxName != null) {
                this.jmxName = override.jmxName;
            }
            if (override.loaderRepository != null) {
                this.loaderRepository = override.loaderRepository;
            }
            if (override.securityDomain != null) {
                this.securityDomain = override.securityDomain;
            }
            if (override.unauthenticatedPrincipal != null) {
                this.unauthenticatedPrincipal = override.unauthenticatedPrincipal;
            }
            if (override.metadataComplete) {
                this.metadataComplete = true;
            }
        }
        if (this.webservices != null && override != null) {
            this.webservices.merge(override.webservices);
        }
        if (this.enterpriseBeans == null) {
            this.enterpriseBeans = new JBossEnterpriseBeansMetaData();
            this.enterpriseBeans.setJBossMetaData(this);
        }
        JBossEnterpriseBeansMetaData jbeans = null;
        if (override != null) {
            jbeans = override.enterpriseBeans;
            if (!override.excludeMissingMethods) {
                this.excludeMissingMethods = false;
            }
        }
        EnterpriseBeansMetaData beans = null;
        if (original != null) {
            beans = original.getEnterpriseBeans();
        }
        boolean isEJB3x = original == null || original.isEJB3x();
        this.enterpriseBeans.merge(jbeans, beans, "ejb-jar.xml", "jboss.xml", !isEJB3x);
        if (this.enterpriseBeans != null) {
            for (JBossEnterpriseBeanMetaData ejb : this.enterpriseBeans) {
                String ejbName = ejb.getEjbName();
                SecurityIdentityMetaData si = ejb.getSecurityIdentity();
                String principalName = si != null ? si.getRunAsPrincipal() : null;
                String ejbXmlRunAs = null;
                if (si != null && si.getRunAs() != null) {
                    ejbXmlRunAs = si.getRunAs().getRoleName();
                }
                if (principalName != null) {
                    if (ejbXmlRunAs == null) {
                        ejbXmlRunAs = "anonymous";
                    }
                    Set<String> extraRoles = null;
                    if (this.getAssemblyDescriptor() != null) {
                        extraRoles = this.getAssemblyDescriptor().getSecurityRoleNamesByPrincipal(principalName);
                    }
                    RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(ejbXmlRunAs, principalName, extraRoles);
                    this.runAsIdentity.put(ejbName, runAsId);
                    continue;
                }
                if (ejbXmlRunAs == null) continue;
                RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(ejbXmlRunAs, null);
                this.runAsIdentity.put(ejbName, runAsId);
            }
        }
    }

    public void merge(JBossMetaData override, JBossMetaData original) {
        super.merge(override, original);
        if (override != null && override.getVersion() != null) {
            this.version = override.getVersion();
        } else if (original != null && original.getVersion() != null) {
            this.version = original.getVersion();
        }
        JBossAssemblyDescriptorMetaData originalAssembly = null;
        InvokerProxyBindingsMetaData originalInvokerProxyBindings = null;
        InterceptorsMetaData originalInterceptors = null;
        WebservicesMetaData originalWebservices = null;
        JBossEnterpriseBeansMetaData originalBeans = null;
        if (original != null) {
            originalAssembly = original.assemblyDescriptor;
            originalInvokerProxyBindings = original.invokerProxyBindings;
            originalInterceptors = original.interceptors;
            originalWebservices = original.webservices;
            originalBeans = original.enterpriseBeans;
            if (original.ejbVersion != null) {
                this.ejbVersion = original.ejbVersion;
            }
            if (original.metadataComplete) {
                this.metadataComplete = true;
            }
            if (original.relationships != null) {
                this.relationships = original.relationships;
            }
            if (original.jaccContextID != null) {
                this.jaccContextID = original.jaccContextID;
            }
            if (original.jmxName != null) {
                this.jmxName = original.jmxName;
            }
            if (original.loaderRepository != null) {
                this.loaderRepository = original.loaderRepository;
            }
            if (original.securityDomain != null) {
                this.securityDomain = original.securityDomain;
            }
            if (original.unauthenticatedPrincipal != null) {
                this.unauthenticatedPrincipal = original.unauthenticatedPrincipal;
            }
            if (original.containerConfigurations != null) {
                if (this.containerConfigurations == null) {
                    this.containerConfigurations = new ContainerConfigurationsMetaData();
                }
                this.containerConfigurations.merge(original.containerConfigurations);
            }
            if (original.resourceManagers != null) {
                if (this.resourceManagers == null) {
                    this.resourceManagers = new ResourceManagersMetaData();
                }
                this.resourceManagers.addAll(original.resourceManagers);
            }
        }
        JBossAssemblyDescriptorMetaData overrideAssembly = null;
        InvokerProxyBindingsMetaData overrideInvokerProxyBindings = null;
        InterceptorsMetaData overrideInterceptors = null;
        WebservicesMetaData overrideWebservices = null;
        JBossEnterpriseBeansMetaData overrideBeans = null;
        if (override != null) {
            overrideAssembly = override.assemblyDescriptor;
            overrideInvokerProxyBindings = override.invokerProxyBindings;
            overrideInterceptors = override.interceptors;
            overrideWebservices = override.webservices;
            overrideBeans = override.enterpriseBeans;
            if (override.ejbVersion != null) {
                this.ejbVersion = override.ejbVersion;
            }
            if (override.metadataComplete) {
                this.metadataComplete = true;
            }
            if (override.relationships != null) {
                this.relationships = original.relationships;
            }
            if (override.jaccContextID != null) {
                this.jaccContextID = override.jaccContextID;
            }
            if (override.jmxName != null) {
                this.jmxName = override.jmxName;
            }
            if (override.loaderRepository != null) {
                this.loaderRepository = override.loaderRepository;
            }
            if (override.securityDomain != null) {
                this.securityDomain = override.securityDomain;
            }
            if (override.unauthenticatedPrincipal != null) {
                this.unauthenticatedPrincipal = override.unauthenticatedPrincipal;
            }
            if (!override.excludeMissingMethods) {
                this.excludeMissingMethods = false;
            }
            if (override.containerConfigurations != null) {
                if (this.containerConfigurations == null) {
                    this.containerConfigurations = new ContainerConfigurationsMetaData();
                }
                this.containerConfigurations.merge(override.containerConfigurations);
            }
            if (override.resourceManagers != null) {
                if (this.resourceManagers == null) {
                    this.resourceManagers = new ResourceManagersMetaData();
                }
                this.resourceManagers.addAll(override.resourceManagers);
            }
        }
        if (this.assemblyDescriptor == null) {
            this.assemblyDescriptor = new JBossAssemblyDescriptorMetaData();
        }
        if (overrideAssembly != null || originalAssembly != null) {
            this.assemblyDescriptor.merge(overrideAssembly, originalAssembly);
        }
        if (this.invokerProxyBindings == null) {
            this.invokerProxyBindings = new InvokerProxyBindingsMetaData();
        }
        if (overrideInvokerProxyBindings != null || originalInvokerProxyBindings != null) {
            this.invokerProxyBindings.merge(overrideInvokerProxyBindings, originalInvokerProxyBindings);
        }
        if (this.interceptors == null) {
            this.interceptors = new InterceptorsMetaData();
        }
        if (overrideInterceptors != null || originalInterceptors != null) {
            this.interceptors.merge(overrideInterceptors, originalInterceptors);
        }
        if (overrideWebservices != null || originalWebservices != null) {
            if (this.webservices == null) {
                this.webservices = new WebservicesMetaData();
            }
            this.webservices.merge(overrideWebservices, originalWebservices);
        }
        if (this.enterpriseBeans == null) {
            this.enterpriseBeans = new JBossEnterpriseBeansMetaData();
            this.enterpriseBeans.setJBossMetaData(this);
        }
        if (originalBeans != null || overrideBeans != null) {
            this.enterpriseBeans.merge(overrideBeans, originalBeans);
        }
        if (this.enterpriseBeans != null) {
            for (JBossEnterpriseBeanMetaData ejb : this.enterpriseBeans) {
                String ejbName = ejb.getEjbName();
                SecurityIdentityMetaData si = ejb.getSecurityIdentity();
                String principalName = si != null ? si.getRunAsPrincipal() : null;
                String ejbXmlRunAs = null;
                if (si != null && si.getRunAs() != null) {
                    ejbXmlRunAs = si.getRunAs().getRoleName();
                }
                if (principalName != null) {
                    if (ejbXmlRunAs == null) {
                        ejbXmlRunAs = "anonymous";
                    }
                    Set<String> extraRoles = null;
                    if (this.getAssemblyDescriptor() != null) {
                        extraRoles = this.getAssemblyDescriptor().getSecurityRoleNamesByPrincipal(principalName);
                    }
                    RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(ejbXmlRunAs, principalName, extraRoles);
                    this.runAsIdentity.put(ejbName, runAsId);
                    continue;
                }
                if (ejbXmlRunAs == null) continue;
                RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(ejbXmlRunAs, null);
                this.runAsIdentity.put(ejbName, runAsId);
            }
        }
    }

    protected JBossEnterpriseBeanMetaData newBean() {
        return null;
    }
}

