/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.logging.jtaLogger;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.XAJMSContext;
import org.jboss.narayana.jta.jms.SessionClosingSynchronization;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class JMSContextProxy
implements JMSContext {
    private final XAJMSContext xaContext;
    private final TransactionHelper transactionHelper;
    private boolean contextCloseScheduled;

    public static JMSContext wrapContext(XAJMSContext xaContext, TransactionHelper transactionHelper) {
        return new JMSContextProxy(xaContext, transactionHelper);
    }

    private JMSContextProxy(XAJMSContext xaContext, TransactionHelper transactionHelper) {
        this.xaContext = xaContext;
        this.transactionHelper = transactionHelper;
        try {
            if (transactionHelper.isTransactionAvailable()) {
                transactionHelper.registerXAResource(xaContext.getXAResource());
            }
        }
        catch (JMSException e) {
            JMSRuntimeException jmsre = new JMSRuntimeException("Could not register the resource");
            jmsre.addSuppressed((Throwable)e);
            throw jmsre;
        }
    }

    public JMSContext createContext(int i) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createContext(i);
    }

    public JMSProducer createProducer() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createProducer();
    }

    public String getClientID() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.getClientID();
    }

    public void setClientID(String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.setClientID(s);
    }

    public ConnectionMetaData getMetaData() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.getMetaData();
    }

    public ExceptionListener getExceptionListener() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.setExceptionListener(exceptionListener);
    }

    public void start() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.start();
    }

    public void stop() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.stop();
    }

    public void setAutoStart(boolean b) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.setAutoStart(b);
    }

    public boolean getAutoStart() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.getAutoStart();
    }

    public void close() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        try {
            if (this.transactionHelper.isTransactionAvailable()) {
                this.transactionHelper.deregisterXAResource(this.xaContext.getXAResource());
                if (jtaLogger.logger.isTraceEnabled()) {
                    jtaLogger.logger.trace((Object)("Delisted " + this.xaContext + " XA resource from the transaction"));
                }
                SessionClosingSynchronization synchronization = new SessionClosingSynchronization((AutoCloseable)this.xaContext);
                this.transactionHelper.registerSynchronization(synchronization);
                if (jtaLogger.logger.isTraceEnabled()) {
                    jtaLogger.logger.trace((Object)("Registered synchronization to close the session: " + synchronization));
                }
                this.contextCloseScheduled = true;
            } else {
                this.xaContext.close();
            }
        }
        catch (JMSException e) {
            JMSRuntimeException jmsre = new JMSRuntimeException("Could not close the context");
            jmsre.addSuppressed((Throwable)e);
            throw jmsre;
        }
    }

    public BytesMessage createBytesMessage() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createBytesMessage();
    }

    public MapMessage createMapMessage() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createMapMessage();
    }

    public Message createMessage() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createMessage();
    }

    public ObjectMessage createObjectMessage() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createObjectMessage();
    }

    public StreamMessage createStreamMessage() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createStreamMessage();
    }

    public TextMessage createTextMessage() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createTextMessage();
    }

    public TextMessage createTextMessage(String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createTextMessage(s);
    }

    public boolean getTransacted() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.getTransacted();
    }

    public int getSessionMode() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.getSessionMode();
    }

    public void commit() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.commit();
    }

    public void rollback() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.rollback();
    }

    public void recover() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.recover();
    }

    public JMSConsumer createConsumer(Destination destination) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createConsumer(destination);
    }

    public JMSConsumer createConsumer(Destination destination, String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createConsumer(destination, s);
    }

    public JMSConsumer createConsumer(Destination destination, String s, boolean b) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createConsumer(destination, s, b);
    }

    public Queue createQueue(String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createQueue(s);
    }

    public Topic createTopic(String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createTopic(s);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createDurableConsumer(topic, s);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String s, String s1, boolean b) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createDurableConsumer(topic, s, s1, b);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createSharedDurableConsumer(topic, s);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String s, String s1) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createSharedDurableConsumer(topic, s, s1);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createSharedConsumer(topic, s);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String s, String s1) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createSharedConsumer(topic, s, s1);
    }

    public QueueBrowser createBrowser(Queue queue) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createBrowser(queue, s);
    }

    public TemporaryQueue createTemporaryQueue() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        return this.xaContext.createTemporaryTopic();
    }

    public void unsubscribe(String s) {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.unsubscribe(s);
    }

    public void acknowledge() {
        if (this.contextCloseScheduled) {
            throw new JMSRuntimeException("This JMSContextProxy is already scheduled to be closed");
        }
        this.xaContext.acknowledge();
    }
}

