/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.osgi.jta.internal;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreIterator;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.log.TransactionTypeManager;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import com.arjuna.ats.internal.arjuna.tools.log.EditableTransaction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.narayana.osgi.jta.ObjStoreBrowserService;

public class ObjStoreBrowserImpl
implements ObjStoreBrowserService {
    private ObjStoreBrowser osb;
    private PrintStream printStream;
    private List<String> recordTypes = new ArrayList<String>();
    private String currentType = null;
    private String currentLog = "";
    private boolean attached = false;

    public ObjStoreBrowserImpl(ObjStoreBrowser osb) {
        try {
            this.printStream = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Encoding " + StandardCharsets.UTF_8.name() + " is not supported");
            throw new IllegalStateException(StandardCharsets.UTF_8.name() + " is not supported");
        }
        this.osb = osb;
    }

    @Override
    public void probe() throws MBeanException {
        this.osb.probe();
    }

    @Override
    public List<String> types() {
        this.recordTypes.clear();
        InputObjectState types = new InputObjectState();
        try {
            if (StoreManager.getRecoveryStore().allTypes(types)) {
                String typeName;
                do {
                    try {
                        typeName = types.unpackString();
                        if (this.recordTypes.contains(typeName)) continue;
                        this.recordTypes.add(typeName);
                    }
                    catch (IOException e) {
                        typeName = "";
                    }
                } while (typeName.length() != 0);
            }
        }
        catch (ObjectStoreException e) {
            System.out.println((Object)e);
        }
        return this.recordTypes;
    }

    @Override
    public boolean select(String itype) {
        if (this.attached) {
            this.attached = false;
        }
        if (this.recordTypes.isEmpty()) {
            this.types();
        }
        if (!this.recordTypes.contains(itype)) {
            this.printStream.printf("%s is not a valid transaction type%n", itype);
            return false;
        }
        this.currentType = itype;
        return true;
    }

    @Override
    public void list(String itype) {
        Set<ObjectInstance> transactions;
        MBeanServer mbs = JMXServer.getAgent().getServer();
        String osMBeanName = this.osb.getObjStoreBrowserMBeanName();
        if (itype != null) {
            if (!this.select(itype)) {
                return;
            }
            osMBeanName = osMBeanName + ",itype=" + itype;
        } else if (this.currentType != null) {
            osMBeanName = osMBeanName + ",itype=" + this.currentType;
        } else {
            this.printStream.printf("No type selected%n", new Object[0]);
            return;
        }
        try {
            transactions = mbs.queryMBeans(new ObjectName(osMBeanName + ",*"), null);
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        for (ObjectInstance oi : transactions) {
            String transactionId = oi.getObjectName().getCanonicalName();
            if (transactionId.contains("puid") || !transactionId.contains("itype")) continue;
            this.printStream.printf("Transaction: %s%n", oi.getObjectName());
            this.printStream.printf("-----------------------------------%n", new Object[0]);
            String participantQuery = transactionId + ",puid=*";
            try {
                Set<ObjectInstance> participants = mbs.queryMBeans(new ObjectName(participantQuery), null);
                this.printAtrributes(this.printStream, "\t", mbs, oi);
                this.printStream.printf("\tParticipants:%n", new Object[0]);
                for (ObjectInstance poi : participants) {
                    this.printStream.printf("\t\tParticipant: %s%n", poi);
                    this.printAtrributes(this.printStream, "\t\t\t", mbs, poi);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.printStream.printf("%n", new Object[0]);
        }
    }

    private void printAtrributes(PrintStream printStream, String printPrefix, MBeanServer mbs, ObjectInstance oi) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        MBeanInfo info = mbs.getMBeanInfo(oi.getObjectName());
        MBeanAttributeInfo[] attributeArray = info.getAttributes();
        int i = 0;
        String[] attributeNames = new String[attributeArray.length];
        for (MBeanAttributeInfo ai : attributeArray) {
            attributeNames[i++] = ai.getName();
        }
        AttributeList attributes = mbs.getAttributes(oi.getObjectName(), attributeNames);
        for (Attribute attribute : attributes.asList()) {
            Object value = attribute.getValue();
            String v = value == null ? "null" : value.toString();
            printStream.printf("%s%s=%s%n", printPrefix, attribute.getName(), v);
        }
    }

    @Override
    public void attach(String id) {
        if (this.attached) {
            System.err.println("Already attached.");
        } else {
            try {
                if (this.supportedLog(id)) {
                    this.currentLog = id;
                    this.attached = true;
                } else {
                    System.err.println("can not attach to id " + id + " with type /" + this.currentType);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void detach() {
        if (!this.attached) {
            System.err.println("Not attached.");
        }
        this.currentLog = "";
        this.attached = false;
    }

    @Override
    public void forget(int idx) {
        if (!this.attached) {
            System.err.println("Not attached.");
        } else if (!this.currentType.contains("AtomicAction")) {
            System.err.println("Can not support this type");
        } else {
            Uid uid = new Uid(this.currentLog);
            EditableTransaction act = TransactionTypeManager.getInstance().getTransaction("AtomicAction", uid);
            try {
                act.moveHeuristicToPrepared(idx);
            }
            catch (IndexOutOfBoundsException ex) {
                System.err.println("Invalid index.");
            }
        }
    }

    @Override
    public void delete(int idx) {
        if (!this.attached) {
            System.err.println("Not attached.");
        } else if (!this.currentType.contains("AtomicAction")) {
            System.err.println("Can not support this type");
        } else {
            Uid uid = new Uid(this.currentLog);
            EditableTransaction act = TransactionTypeManager.getInstance().getTransaction("AtomicAction", uid);
            try {
                act.deleteHeuristicParticipant(idx);
            }
            catch (IndexOutOfBoundsException ex) {
                System.err.println("Invalid index.");
            }
        }
    }

    private final boolean supportedLog(String logID) throws ObjectStoreException, IOException {
        Uid id = new Uid(logID);
        if (id.equals(Uid.nullUid())) {
            System.err.println(logID + " is null Uid");
        } else if (this.currentType == null) {
            this.printStream.printf("No type selected%n", new Object[0]);
        } else if (!this.currentType.contains("AtomicAction")) {
            this.printStream.printf("Can not support this type", new Object[0]);
        } else {
            Uid u;
            ObjectStoreIterator iter = new ObjectStoreIterator(StoreManager.getRecoveryStore(), "/" + this.currentType);
            do {
                if (!(u = iter.iterate()).equals(id)) continue;
                return true;
            } while (Uid.nullUid().notEquals(u));
        }
        return false;
    }

    @Override
    public void start() {
        this.osb.start();
    }

    @Override
    public void stop() {
        this.osb.stop();
    }
}

