/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.osgi.jta.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

@Deprecated
public class Activator
implements BundleActivator,
ManagedService,
Runnable {
    public static final String PID = "org.jboss.narayana";
    public static final String INTERN_PACKAGE = "org.jboss.narayana.osgi.jta.internal";
    public static final String SERVER_CLASS = "org.jboss.narayana.osgi.jta.internal.OsgiServer";
    protected BundleContext bundleContext;
    protected ExecutorService executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private AtomicBoolean scheduled = new AtomicBoolean();
    private long schedulerStopTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private ServiceRegistration managedServiceRegistration;
    private Dictionary<String, ?> configuration;
    private Object service;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.scheduled.set(true);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", PID);
        this.managedServiceRegistration = this.bundleContext.registerService(ManagedService.class, (Object)this, props);
        this.scheduled.set(false);
        this.reconfigure();
    }

    public void stop(BundleContext context) throws Exception {
        this.scheduled.set(true);
        if (this.managedServiceRegistration != null) {
            this.managedServiceRegistration.unregister();
        }
        this.executor.shutdown();
        this.executor.awaitTermination(this.schedulerStopTimeout, TimeUnit.MILLISECONDS);
        this.doStop();
    }

    ClassLoader createClassLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String name = SERVER_CLASS.replace('.', '/') + ".class";
        URL url = this.bundleContext.getBundle().getResource(name);
        String strUrl = url.toExternalForm();
        if (!strUrl.endsWith(name)) {
            throw new IllegalStateException();
        }
        strUrl = strUrl.substring(0, strUrl.length() - name.length());
        try {
            urls.add(new URL(strUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        Collection resources = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).listResources("/", "*.jar", 2);
        for (String resource : resources) {
            urls.add(this.bundleContext.getBundle().getResource(resource));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), new ClassLoader(this.getClass().getClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith(Activator.INTERN_PACKAGE)) {
                    throw new ClassNotFoundException(name);
                }
                return super.loadClass(name, resolve);
            }
        });
    }

    protected void doStart() throws Exception {
        ClassLoader classLoader = this.createClassLoader();
        Class<?> osgiServerClass = classLoader.loadClass(SERVER_CLASS);
        this.service = osgiServerClass.getConstructor(BundleContext.class, Dictionary.class).newInstance(this.bundleContext, this.configuration);
        this.service.getClass().getMethod("start", new Class[0]).invoke(this.service, new Object[0]);
    }

    protected void doStop() {
        if (this.service != null) {
            try {
                this.service.getClass().getMethod("stop", new Class[0]).invoke(this.service, new Object[0]);
            }
            catch (Throwable t) {
                this.warn("Error stopping service", t);
            }
            finally {
                this.service = null;
            }
        }
    }

    public void updated(Dictionary<String, ?> properties) {
        this.configuration = properties;
        this.reconfigure();
    }

    protected void reconfigure() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.executor.submit(this);
        }
    }

    @Override
    public void run() {
        this.scheduled.set(false);
        this.doStop();
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.warn("Error starting service", e);
            this.doStop();
        }
    }

    protected void warn(String message, Throwable t) {
        ServiceReference ref = this.bundleContext.getServiceReference(LogService.class);
        if (ref != null) {
            LogService svc = (LogService)this.bundleContext.getService(ref);
            svc.log(2, message, t);
            this.bundleContext.ungetService(ref);
        }
    }
}

