/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.osgi.jta.internal;

import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.narayana.osgi.jta.ObjStoreBrowserService;
import org.jboss.narayana.osgi.jta.internal.ObjStoreBrowserImpl;
import org.jboss.narayana.osgi.jta.internal.OsgiTransactionManager;
import org.jboss.narayana.osgi.jta.internal.PlatformTransactionManagerImple;
import org.jboss.tm.XAResourceRecovery;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiServer
implements ServiceTrackerCustomizer<XAResourceRecovery, XAResourceRecovery> {
    private final BundleContext bundleContext;
    private final Dictionary<String, ?> configuration;
    List<ServiceRegistration> registrations;
    ServiceTracker<XAResourceRecovery, XAResourceRecovery> resourceRecoveryTracker;
    TransactionManagerService transactionManagerService;
    RecoveryManagerService recoveryManagerService;
    ObjStoreBrowserService objStoreBrowserService;

    public OsgiServer(BundleContext bundleContext, Dictionary<String, ?> configuration) {
        this.bundleContext = bundleContext;
        this.configuration = configuration;
    }

    public void start() throws Exception {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.doStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    public void doStart() throws Exception {
        Properties properties = PropertiesFactory.getDefaultProperties();
        if (this.configuration != null) {
            Enumeration<String> keyEnum = this.configuration.keys();
            while (keyEnum.hasMoreElements()) {
                String key = keyEnum.nextElement();
                String val = this.configuration.get(key).toString();
                properties.put(key, val);
            }
        }
        OsgiTransactionManager transactionManager = new OsgiTransactionManager();
        JTAEnvironmentBean jtaEnvironmentBean = jtaPropertyManager.getJTAEnvironmentBean();
        jtaEnvironmentBean.setTransactionManager((TransactionManager)((Object)transactionManager));
        jtaEnvironmentBean.setUserTransaction((UserTransaction)transactionManager);
        RecoveryManagerService rmSvc = new RecoveryManagerService();
        rmSvc.create();
        this.recoveryManagerService = rmSvc;
        this.resourceRecoveryTracker = new ServiceTracker(this.bundleContext, XAResourceRecovery.class, (ServiceTrackerCustomizer)this);
        TransactionManagerService tmSvc = new TransactionManagerService();
        tmSvc.setTransactionSynchronizationRegistry(jtaEnvironmentBean.getTransactionSynchronizationRegistry());
        tmSvc.create();
        this.transactionManagerService = tmSvc;
        ObjStoreBrowser osb = new ObjStoreBrowser();
        osb.setExposeAllRecordsAsMBeans(true);
        this.objStoreBrowserService = new ObjStoreBrowserImpl(osb);
        this.resourceRecoveryTracker.open();
        this.transactionManagerService.start();
        this.recoveryManagerService.start();
        this.objStoreBrowserService.start();
        this.register(TransactionManager.class, this.transactionManagerService.getTransactionManager());
        this.register(TransactionSynchronizationRegistry.class, this.transactionManagerService.getTransactionSynchronizationRegistry());
        this.register(UserTransaction.class, this.transactionManagerService.getUserTransaction());
        this.register(ObjStoreBrowserService.class, this.objStoreBrowserService);
        try {
            this.registrations.add(PlatformTransactionManagerImple.register(this.bundleContext, (OsgiTransactionManager)((Object)this.transactionManagerService.getTransactionManager())));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.doStop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        if (this.registrations != null) {
            for (ServiceRegistration reg : this.registrations) {
                try {
                    reg.unregister();
                }
                catch (Throwable t) {
                    this.warn("Error unregistering service", t);
                }
            }
            this.registrations = null;
        }
        if (this.transactionManagerService != null) {
            try {
                try {
                    this.transactionManagerService.stop();
                }
                finally {
                    this.transactionManagerService.destroy();
                }
            }
            catch (Throwable t) {
                this.warn("Error stopping transaction manager service", t);
            }
            finally {
                this.transactionManagerService = null;
            }
        }
        if (this.recoveryManagerService != null) {
            try {
                try {
                    this.recoveryManagerService.stop();
                }
                finally {
                    this.recoveryManagerService.destroy();
                }
            }
            catch (Throwable t) {
                this.warn("Error stopping recovery manager service", t);
            }
            finally {
                this.recoveryManagerService = null;
            }
        }
        if (this.resourceRecoveryTracker != null) {
            try {
                this.resourceRecoveryTracker.close();
            }
            catch (Throwable t) {
                this.warn("Error stopping resource recovery tracker", t);
            }
            finally {
                this.resourceRecoveryTracker = null;
            }
        }
        if (this.objStoreBrowserService != null) {
            try {
                this.objStoreBrowserService.stop();
            }
            catch (Throwable t) {
                this.warn("Error stopping object browser", t);
            }
            finally {
                this.objStoreBrowserService = null;
            }
        }
        TransactionReaper.terminate((boolean)false);
        TxControl.disable((boolean)true);
        StoreManager.shutdown();
    }

    protected <T> void register(Class<T> clazz, T service) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("provider", "narayana");
        ServiceRegistration registration = this.bundleContext.registerService(clazz, service, props);
        if (this.registrations == null) {
            this.registrations = new ArrayList<ServiceRegistration>();
        }
        this.registrations.add(registration);
    }

    protected void warn(String message, Throwable t) {
        ServiceReference ref = this.bundleContext.getServiceReference(LogService.class);
        if (ref != null) {
            LogService svc = (LogService)this.bundleContext.getService(ref);
            svc.log(2, message, t);
            this.bundleContext.ungetService(ref);
        }
    }

    public XAResourceRecovery addingService(ServiceReference<XAResourceRecovery> reference) {
        XAResourceRecovery resourceRecovery = (XAResourceRecovery)this.bundleContext.getService(reference);
        this.recoveryManagerService.addXAResourceRecovery(resourceRecovery);
        return resourceRecovery;
    }

    public void modifiedService(ServiceReference<XAResourceRecovery> reference, XAResourceRecovery service) {
    }

    public void removedService(ServiceReference<XAResourceRecovery> reference, XAResourceRecovery resourceRecovery) {
        this.recoveryManagerService.removeXAResourceRecovery(resourceRecovery);
        this.bundleContext.ungetService(reference);
    }
}

