/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wscoor.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.wscoor.client.WSCOORClient;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.ActivationPortType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContext;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CreateCoordinationContextResponseType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CreateCoordinationContextType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.Expires;

public class ActivationCoordinatorClient {
    private static final ActivationCoordinatorClient CLIENT = new ActivationCoordinatorClient();

    private ActivationCoordinatorClient() {
    }

    public CreateCoordinationContextResponseType sendCreateCoordination(MAP map, String coordinationType, Expires expires, CoordinationContext currentContext) throws SoapFault, IOException {
        CreateCoordinationContextType request = new CreateCoordinationContextType();
        request.setCoordinationType(coordinationType);
        request.setExpires(expires);
        if (currentContext != null) {
            CreateCoordinationContextType.CurrentContext current = new CreateCoordinationContextType.CurrentContext();
            current.setCoordinationType(currentContext.getCoordinationType());
            current.setExpires(currentContext.getExpires());
            current.setIdentifier(currentContext.getIdentifier());
            current.setRegistrationService(currentContext.getRegistrationService());
            current.getAny().addAll(currentContext.getAny());
            request.setCurrentContext(current);
        } else {
            request.setCurrentContext(null);
        }
        ActivationPortType port = WSCOORClient.getActivationPort(map, "http://docs.oasis-open.org/ws-tx/wscoor/2006/06/CreateCoordinationContext");
        return this.createCoordinationContextOperation(port, request);
    }

    private CreateCoordinationContextResponseType createCoordinationContextOperation(final ActivationPortType port, final CreateCoordinationContextType request) {
        if (System.getSecurityManager() == null) {
            return port.createCoordinationContextOperation(request);
        }
        return AccessController.doPrivileged(new PrivilegedAction<CreateCoordinationContextResponseType>(){

            @Override
            public CreateCoordinationContextResponseType run() {
                return port.createCoordinationContextOperation(request);
            }
        });
    }

    public static ActivationCoordinatorClient getClient() {
        return CLIENT;
    }
}

