/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.PreferredStreamMarshaller;
import org.jboss.remoting.marshal.PreferredStreamUnMarshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.OpenConnectionChecker;
import org.jboss.remoting.transport.socket.SocketWrapper;
import org.jboss.remoting.transport.socket.TimedOutputStream;

public class ClientSocketWrapper
extends SocketWrapper
implements OpenConnectionChecker {
    private static final Logger log = Logger.getLogger((Class)ClientSocketWrapper.class);
    private static boolean trace = log.isTraceEnabled();
    private InputStream in;
    private OutputStream out;
    private int writeTimeout = -1;

    public ClientSocketWrapper(Socket socket) throws IOException {
        super(socket);
        this.createStreams(socket, null);
    }

    public ClientSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception {
        super(socket, timeout);
        this.createStreams(socket, metadata);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void checkConnection() throws IOException {
        boolean ACK = true;
        this.out.write(1);
        this.out.flush();
        int i = this.in.read();
        if (trace) {
            log.trace((Object)(this + " got " + i + " while checking connection"));
        }
    }

    public void checkOpenConnection() throws IOException {
        if (trace) {
            log.trace((Object)"checking open connection");
        }
        if (this.in.available() > 1) {
            log.trace((Object)"remote endpoint has closed");
            throw new IOException("remote endpoint has closed");
        }
    }

    public String toString() {
        Socket socket = this.getSocket();
        return "ClientSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
    }

    protected void createStreams(Socket socket, Map metadata) throws IOException {
        String serializationType = "java";
        if (metadata != null) {
            String serializationTypeParam = (String)metadata.get("serializationtype");
            if (serializationTypeParam == null || serializationTypeParam.length() == 0) {
                serializationTypeParam = (String)metadata.get("serializationType");
            }
            if (serializationTypeParam != null && serializationTypeParam.length() > 0) {
                serializationType = serializationTypeParam;
            }
        }
        Marshaller marshaller = null;
        UnMarshaller unmarshaller = null;
        int tempTimeout = -1;
        int savedTimeout = this.getTimeout();
        if (metadata != null) {
            marshaller = (Marshaller)metadata.get("marshaller");
            unmarshaller = (UnMarshaller)metadata.get("unmarshaller");
            Object o = metadata.get("temptimeout");
            if (o instanceof Integer && (tempTimeout = ((Integer)o).intValue()) != -1) {
                socket.setSoTimeout(tempTimeout);
                log.trace((Object)("set temp timeout to: " + tempTimeout));
            }
            if ((o = metadata.get("writeTimeout")) instanceof Integer) {
                this.writeTimeout = (Integer)o;
                if (this.writeTimeout != -1) {
                    log.trace((Object)("set writeTimeout to: " + this.writeTimeout));
                }
            }
        }
        this.out = this.createOutputStream(serializationType, socket, marshaller);
        this.in = this.createInputStream(serializationType, socket, unmarshaller);
        this.setTimeout(savedTimeout);
        log.trace((Object)("reset timeout: " + savedTimeout));
    }

    protected InputStream createInputStream(String serializationType, Socket socket, UnMarshaller unmarshaller) throws IOException {
        if (trace) {
            log.trace((Object)(this + " getting input stream from " + socket + ", " + unmarshaller));
        }
        if (unmarshaller == null) {
            log.warn((Object)"got null unmarshaller");
        }
        InputStream is = socket.getInputStream();
        if (unmarshaller instanceof PreferredStreamUnMarshaller) {
            PreferredStreamUnMarshaller psum = (PreferredStreamUnMarshaller)unmarshaller;
            is = psum.getMarshallingStream(is);
        }
        return is;
    }

    protected OutputStream createOutputStream(String serializationType, Socket socket, Marshaller marshaller) throws IOException {
        if (trace) {
            log.trace((Object)(this + " getting output stream from " + socket + ", " + marshaller));
        }
        if (marshaller == null) {
            log.warn((Object)"got null marshaller");
        }
        OutputStream os = socket.getOutputStream();
        if (this.writeTimeout > 0) {
            os = new TimedOutputStream(os, this.writeTimeout);
            if (trace) {
                log.trace((Object)(this + " created TimedOutputStream: " + os));
            }
        }
        if (marshaller instanceof PreferredStreamMarshaller) {
            PreferredStreamMarshaller psm = (PreferredStreamMarshaller)marshaller;
            os = psm.getMarshallingStream(os);
        }
        return os;
    }
}

