/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.xnio.Cancellable;

public abstract class MessageOutputStream
extends OutputStream
implements DataOutput,
Cancellable {
    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract MessageOutputStream cancel();

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(v >> 8);
        this.write(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.write(v >> 8);
        this.write(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.write(v >> 24);
        this.write(v >> 16);
        this.write(v >> 8);
        this.write(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.write((int)(v >> 56));
        this.write((int)(v >> 48));
        this.write((int)(v >> 40));
        this.write((int)(v >> 32));
        this.write((int)(v >> 24));
        this.write((int)(v >> 16));
        this.write((int)(v >> 8));
        this.write((int)v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        char c;
        int len = s.length();
        int outLen = 0;
        for (int i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++outLen;
                continue;
            }
            if (c <= '\u07ff') {
                outLen += 2;
                continue;
            }
            outLen += 3;
        }
        if (outLen > 65535) {
            throw MessageOutputStream.tooLong();
        }
        byte[] bytes = new byte[outLen + 2];
        bytes[0] = (byte)(outLen >> 8);
        bytes[1] = (byte)outLen;
        int j = 2;
        for (int i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[j++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                bytes[j++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[j++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytes[j++] = (byte)(0xE0 | c >> 12 & 0x1F);
            bytes[j++] = (byte)(0x80 | c >> 6 & 0x1F);
            bytes[j++] = (byte)(0x80 | c & 0x3F);
        }
        this.write(bytes, 0, bytes.length);
    }

    private static UTFDataFormatException tooLong() {
        return new UTFDataFormatException("String too long");
    }
}

