/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenGABaseImpl;

class MavenCoordinateImpl
extends MavenGABaseImpl
implements MavenCoordinate {
    private static final String EMPTY_STRING = "";
    private final String version;
    private final PackagingType packaging;
    private final String classifier;

    MavenCoordinateImpl(String groupId, String artifactId, String version, PackagingType packaging, String classifier) {
        super(groupId, artifactId);
        this.version = version;
        this.packaging = packaging == null ? PackagingType.JAR : packaging;
        this.classifier = classifier == null ? packaging.getClassifier() : classifier;
    }

    @Override
    public final PackagingType getPackaging() {
        return this.packaging;
    }

    @Override
    public final PackagingType getType() {
        return this.packaging;
    }

    @Override
    public final String getClassifier() {
        return this.classifier;
    }

    @Override
    public final String getVersion() {
        return this.version;
    }

    @Override
    public final String toCanonicalForm() {
        StringBuilder sb = new StringBuilder(super.toCanonicalForm());
        if (this.version == null || this.version.length() == 0) {
            return sb.toString();
        }
        if (this.classifier != null && this.classifier.length() > 0 && this.packaging != null) {
            sb.append(':').append(this.packaging.getId()).append(':').append(this.classifier).append(':').append(this.version);
        }
        if ((this.classifier == null || this.classifier.length() == 0) && this.packaging != null) {
            sb.append(':').append(this.packaging.getId()).append(':').append(this.version);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.packaging == null ? 0 : this.packaging.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenCoordinateImpl other = (MavenCoordinateImpl)obj;
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        return this.packaging.equals(other.packaging);
    }

    public String toString() {
        return MavenCoordinate.class.getSimpleName() + " [" + this.toCanonicalForm() + "]";
    }
}

