/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class MarkerFileHandler {
    private final File markerFile;
    private final Logger log = Logger.getLogger(MarkerFileHandler.class.getName());

    MarkerFileHandler(File destinationDir, String markerFileName) {
        this.markerFile = Paths.get(destinationDir.getPath(), markerFileName).toFile();
    }

    void createMarkerFile() {
        try {
            this.markerFile.createNewFile();
            this.markerFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteMarkerFile() {
        if (this.markerFile.exists() && !this.markerFile.delete()) {
            this.log.warning("failed to delete marker file: " + this.markerFile);
        }
    }

    boolean waitTillMarkerFileIsGone(long timeoutInMilliseconds, String processName) {
        int count = 0;
        while (this.isMarkerFilePresent() && (long)count < timeoutInMilliseconds / 100L) {
            if (count == 0) {
                System.out.println(String.format("There is marker file %s, which means that some other process is already processing the %s - waiting to be completed.", this.markerFile, processName));
            }
            System.out.print(".");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.log.warning("Problem occurred when the thread was sleeping:\n" + e.getMessage());
            }
            ++count;
        }
        System.out.println();
        return count == 100 && this.isMarkerFilePresent();
    }

    boolean isMarkerFilePresent() {
        return this.markerFile.exists();
    }
}

