/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.Container;
import org.jboss.weld.bean.CommonBean;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;

@SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="bean field is loaded lazily")
public class ProxyMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 5293834510764991583L;
    private final BeanInstance beanInstance;
    private final BeanIdentifier beanId;
    private transient Bean<?> bean;
    private final String contextId;

    public ProxyMethodHandler(String contextId, BeanInstance beanInstance, Bean<?> bean) {
        this.beanInstance = beanInstance;
        this.bean = bean;
        this.contextId = contextId;
        this.beanId = bean instanceof CommonBean ? ((CommonBean)bean).getIdentifier() : (bean instanceof PassivationCapable ? new StringBeanIdentifier(((PassivationCapable)((Object)bean)).getId()) : null);
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (thisMethod == null) {
            BeanLogger.LOG.methodHandlerProcessingReturningBeanInstance(self.getClass());
            if (this.beanInstance == null) {
                throw BeanLogger.LOG.beanInstanceNotSetOnProxy(this.getBean());
            }
            return this.beanInstance.getInstance();
        }
        BeanLogger.LOG.methodHandlerProcessingCall(thisMethod, self.getClass());
        if (thisMethod.getDeclaringClass().equals(TargetInstanceProxy.class)) {
            if (this.beanInstance == null) {
                throw BeanLogger.LOG.beanInstanceNotSetOnProxy(this.getBean());
            }
            if (thisMethod.getName().equals("getTargetInstance")) {
                return this.beanInstance.getInstance();
            }
            if (thisMethod.getName().equals("getTargetClass")) {
                return this.beanInstance.getInstanceType();
            }
            return null;
        }
        if (thisMethod.getName().equals("_initMH")) {
            BeanLogger.LOG.settingNewMethodHandler(args[0], self.getClass());
            return new ProxyMethodHandler(this.contextId, new TargetBeanInstance(args[0]), this.getBean());
        }
        if (this.beanInstance == null) {
            throw BeanLogger.LOG.beanInstanceNotSetOnProxy(this.getBean());
        }
        Object instance = this.beanInstance.getInstance();
        Object result = this.beanInstance.invoke(instance, thisMethod, args);
        if (result != null && result == instance && thisMethod.getReturnType().isAssignableFrom(self.getClass())) {
            return self;
        }
        return result;
    }

    public Bean<?> getBean() {
        if (this.bean == null) {
            if (this.beanId == null) {
                throw BeanLogger.LOG.proxyHandlerSerializedForNonSerializableBean();
            }
            this.bean = (Bean)Container.instance(this.contextId).services().get(ContextualStore.class).getContextual(this.beanId);
        }
        return this.bean;
    }
}

