/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.builder.InterceptionModelBuilder;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

class InterceptionModelImpl<T>
implements InterceptionModel<T> {
    private final Map<InterceptionType, List<InterceptorMetadata<?>>> globalInterceptors;
    private final Map<InterceptionType, Map<Method, List<InterceptorMetadata<?>>>> methodBoundInterceptors;
    private final Set<Method> methodsIgnoringGlobalInterceptors;
    private final Set<InterceptorMetadata<?>> allInterceptors;
    private final T interceptedEntity;
    private final boolean hasTargetClassInterceptors;
    private final boolean hasExternalNonConstructorInterceptors;

    InterceptionModelImpl(InterceptionModelBuilder<T> builder) {
        this.interceptedEntity = builder.getInterceptedEntity();
        this.hasTargetClassInterceptors = builder.isHasTargetClassInterceptors();
        this.hasExternalNonConstructorInterceptors = builder.isHasExternalNonConstructorInterceptors();
        this.globalInterceptors = ImmutableMap.copyOf(builder.getGlobalInterceptors());
        this.methodBoundInterceptors = ImmutableMap.copyOf(builder.getMethodBoundInterceptors());
        this.methodsIgnoringGlobalInterceptors = ImmutableSet.copyOf(builder.getMethodsIgnoringGlobalInterceptors());
        this.allInterceptors = ImmutableSet.copyOf(builder.getAllInterceptors());
    }

    @Override
    public List<InterceptorMetadata<?>> getInterceptors(InterceptionType interceptionType, Method method) {
        if (InterceptionType.AROUND_CONSTRUCT.equals((Object)interceptionType)) {
            throw new IllegalStateException("Cannot use getInterceptors() for @AroundConstruct interceptor lookup. Use getConstructorInvocationInterceptors() instead.");
        }
        if (interceptionType.isLifecycleCallback() && method != null) {
            throw new IllegalArgumentException("On a lifecycle callback, the associated method must be null");
        }
        if (!interceptionType.isLifecycleCallback() && method == null) {
            throw new IllegalArgumentException("Around-invoke and around-timeout interceptors are defined for a given method");
        }
        if (interceptionType.isLifecycleCallback()) {
            if (this.globalInterceptors.containsKey((Object)interceptionType)) {
                return this.globalInterceptors.get((Object)interceptionType);
            }
        } else {
            List<InterceptorMetadata<?>> list;
            Map<Method, List<InterceptorMetadata<?>>> map;
            ArrayList returnedInterceptors = new ArrayList();
            if (!this.methodsIgnoringGlobalInterceptors.contains(method) && this.globalInterceptors.containsKey((Object)interceptionType)) {
                returnedInterceptors.addAll((Collection)this.globalInterceptors.get((Object)interceptionType));
            }
            if ((map = this.methodBoundInterceptors.get((Object)interceptionType)) != null && (list = map.get(method)) != null) {
                returnedInterceptors.addAll(list);
            }
            return returnedInterceptors;
        }
        return Collections.emptyList();
    }

    @Override
    public Set<InterceptorMetadata<?>> getAllInterceptors() {
        return Collections.unmodifiableSet(this.allInterceptors);
    }

    @Override
    public T getInterceptedEntity() {
        return this.interceptedEntity;
    }

    @Override
    public List<InterceptorMetadata<?>> getConstructorInvocationInterceptors() {
        if (this.globalInterceptors.containsKey((Object)InterceptionType.AROUND_CONSTRUCT)) {
            return this.globalInterceptors.get((Object)InterceptionType.AROUND_CONSTRUCT);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasExternalConstructorInterceptors() {
        return !this.getConstructorInvocationInterceptors().isEmpty();
    }

    @Override
    public boolean hasExternalNonConstructorInterceptors() {
        return this.hasExternalNonConstructorInterceptors;
    }

    @Override
    public boolean hasTargetClassInterceptors() {
        return this.hasTargetClassInterceptors;
    }
}

