/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public class LockStore
implements Serializable {
    private static final long serialVersionUID = -698649566870070414L;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private volatile transient Map<BeanIdentifier, ReferenceCountedLock> locks = new HashMap<BeanIdentifier, ReferenceCountedLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedBean lock(BeanIdentifier id) {
        ReferenceCountedLock refLock;
        LockStore lockStore = this;
        synchronized (lockStore) {
            if (this.locks == null) {
                this.locks = new HashMap<BeanIdentifier, ReferenceCountedLock>();
            }
            if ((refLock = this.locks.get(id)) != null) {
                ++refLock.count;
            } else {
                refLock = new ReferenceCountedLock(id);
                this.locks.put(id, refLock);
            }
        }
        refLock.lock.lock();
        return refLock;
    }

    private class ReferenceCountedLock
    implements LockedBean {
        private final BeanIdentifier key;
        int count = 1;
        final ReentrantLock lock = new ReentrantLock();

        private ReferenceCountedLock(BeanIdentifier key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            LockStore lockStore = LockStore.this;
            synchronized (lockStore) {
                this.lock.unlock();
                --this.count;
                if (this.count == 0) {
                    LockStore.this.locks.remove(this.key);
                }
            }
        }
    }
}

