/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.undertow;

import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.servlet.logging.UndertowLogger;
import org.jboss.weld.environment.undertow.WeldServletExtension;
import org.jboss.weld.resources.spi.ResourceLoader;

public class UndertowContainer
implements Container {
    public static final UndertowContainer INSTANCE = new UndertowContainer();
    private static final String UDT_SERVLET_PREFIX = "io.undertow.servlet";

    @Override
    public boolean touch(ResourceLoader resourceLoader, ContainerContext context) throws Exception {
        return context.getServletContext().getClass().getName().startsWith(UDT_SERVLET_PREFIX);
    }

    @Override
    public void initialize(ContainerContext context) {
        Object value = context.getServletContext().getAttribute(WeldServletExtension.INSTALLED);
        if ("full".equals(value)) {
            UndertowLogger.LOG.undertowDetected();
        } else if ("servlet-only".equals(value)) {
            UndertowLogger.LOG.undertowDetectedServletOnly();
        }
    }

    @Override
    public void destroy(ContainerContext context) {
    }
}

