/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.decorator.Decorator;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;

final class BeanManagerAccess {
    private static BeanManager beanManager;

    private BeanManagerAccess() {
    }

    static void set(BeanManager beanManager) {
        BeanManagerAccess.beanManager = beanManager;
    }

    static void remove() {
        beanManager = null;
    }

    static <T> AnnotatedType<T> createAnnotatedType(Class<T> clazz) {
        if (beanManager == null) {
            throw new IllegalStateException("BeanManagerAccess.createAnnotatedType can only be called within an extension method");
        }
        return beanManager.createAnnotatedType(clazz);
    }

    static boolean isBeanDefiningAnnotation(Class<? extends Annotation> annotationType) {
        if (beanManager == null) {
            throw new IllegalStateException("BeanManagerAccess.isBeanDefiningAnnotation can only be called within an extension method");
        }
        return beanManager.isNormalScope(annotationType) || beanManager.isStereotype(annotationType) || Dependent.class.equals(annotationType) || Interceptor.class.equals(annotationType) || Decorator.class.equals(annotationType);
    }
}

