/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.FieldConfig;
import jakarta.enterprise.inject.build.compatible.spi.MethodConfig;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationProxy;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldConfigImpl;
import org.jboss.weld.lite.extension.translator.MethodConfigImpl;
import org.jboss.weld.lite.extension.translator.MethodConstructorConfigImpl;

class ClassConfigImpl
implements ClassConfig {
    private final AnnotatedTypeConfigurator<?> configurator;

    ClassConfigImpl(AnnotatedTypeConfigurator<?> configurator) {
        this.configurator = configurator;
    }

    public ClassInfo info() {
        return new ClassInfoImpl(this.configurator.getAnnotated());
    }

    public ClassConfig addAnnotation(Class<? extends Annotation> annotationType) {
        this.configurator.add(AnnotationProxy.create(annotationType, Collections.emptyMap()));
        return this;
    }

    public ClassConfig addAnnotation(AnnotationInfo annotation) {
        this.configurator.add(((AnnotationInfoImpl)annotation).annotation);
        return this;
    }

    public ClassConfig addAnnotation(Annotation annotation) {
        this.configurator.add(annotation);
        return this;
    }

    public ClassConfig removeAnnotation(Predicate<AnnotationInfo> predicate) {
        this.configurator.remove(annotation -> predicate.test(new AnnotationInfoImpl((Annotation)annotation)));
        return this;
    }

    public ClassConfig removeAllAnnotations() {
        this.configurator.removeAll();
        return this;
    }

    public Collection<MethodConfig> constructors() {
        return this.configurator.constructors().stream().map(MethodConstructorConfigImpl::new).collect(Collectors.toList());
    }

    public Collection<MethodConfig> methods() {
        return this.configurator.methods().stream().map(MethodConfigImpl::new).collect(Collectors.toList());
    }

    public Collection<FieldConfig> fields() {
        return this.configurator.fields().stream().map(FieldConfigImpl::new).collect(Collectors.toList());
    }
}

