/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationTargetImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.ParameterInfoImpl;

abstract class DeclarationInfoImpl<ReflectionDeclaration extends AnnotatedElement, CdiDeclaration extends Annotated>
extends AnnotationTargetImpl<ReflectionDeclaration>
implements DeclarationInfo {
    final CdiDeclaration cdiDeclaration;

    DeclarationInfoImpl(ReflectionDeclaration reflectionDeclaration, CdiDeclaration cdiDeclaration) {
        super(reflectionDeclaration, null);
        this.cdiDeclaration = cdiDeclaration;
    }

    static DeclarationInfo fromCdiDeclaration(Annotated cdiDeclaration) {
        Objects.requireNonNull(cdiDeclaration);
        if (cdiDeclaration instanceof AnnotatedType) {
            return new ClassInfoImpl((AnnotatedType)cdiDeclaration);
        }
        if (cdiDeclaration instanceof AnnotatedCallable) {
            return new MethodInfoImpl((AnnotatedCallable)cdiDeclaration);
        }
        if (cdiDeclaration instanceof AnnotatedParameter) {
            return new ParameterInfoImpl((AnnotatedParameter)cdiDeclaration);
        }
        if (cdiDeclaration instanceof AnnotatedField) {
            return new FieldInfoImpl((AnnotatedField)cdiDeclaration);
        }
        throw new IllegalArgumentException("Unknown declaration " + cdiDeclaration);
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        if (this.cdiDeclaration == null) {
            return super.hasAnnotation(annotationType);
        }
        return this.cdiDeclaration.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        if (this.cdiDeclaration == null) {
            return super.hasAnnotation(predicate);
        }
        return this.cdiDeclaration.getAnnotations().stream().anyMatch(it -> predicate.test(new AnnotationInfoImpl((Annotation)it)));
    }

    @Override
    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        if (this.cdiDeclaration == null) {
            return super.annotation(annotationType);
        }
        Annotation annotation = this.cdiDeclaration.getAnnotation(annotationType);
        return annotation == null ? null : new AnnotationInfoImpl(annotation);
    }

    @Override
    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        if (this.cdiDeclaration == null) {
            return super.repeatableAnnotation(annotationType);
        }
        return this.cdiDeclaration.getAnnotations(annotationType).stream().map(AnnotationInfoImpl::new).collect(Collectors.toList());
    }

    @Override
    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        if (this.cdiDeclaration == null) {
            return super.annotations(predicate);
        }
        return this.cdiDeclaration.getAnnotations().stream().map(AnnotationInfoImpl::new).filter(predicate).collect(Collectors.toList());
    }

    public String toString() {
        return this.cdiDeclaration != null ? this.cdiDeclaration.toString() : this.reflection.toString();
    }
}

