/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.util.collections.ImmutableMap;

public final class Defaults {
    private static final Map<Class<?>, Object> JLS_PRIMITIVE_DEFAULT_VALUES;

    private Defaults() {
    }

    private static <T> void put(Map<Class<?>, Object> map, Class<T> type, T value) {
        map.put(type, value);
    }

    public static <T> T getJlsDefaultValue(Class<T> type) {
        if (!type.isPrimitive()) {
            return null;
        }
        return (T)JLS_PRIMITIVE_DEFAULT_VALUES.get(type);
    }

    static {
        HashMap values = new HashMap();
        Defaults.put(values, Boolean.TYPE, false);
        Defaults.put(values, Character.TYPE, Character.valueOf('\u0000'));
        Defaults.put(values, Byte.TYPE, (byte)0);
        Defaults.put(values, Short.TYPE, (short)0);
        Defaults.put(values, Integer.TYPE, 0);
        Defaults.put(values, Long.TYPE, 0L);
        Defaults.put(values, Float.TYPE, Float.valueOf(0.0f));
        Defaults.put(values, Double.TYPE, 0.0);
        JLS_PRIMITIVE_DEFAULT_VALUES = ImmutableMap.builder().putAll(values).build();
    }
}

