/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.ArrayList;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.NodeContainerBuilder;
import org.kie.api.fluent.SubProcessNodeBuilder;

public class SubProcessNodeFactory<T extends NodeContainerBuilder<T, ?>>
extends NodeFactory<SubProcessNodeBuilder<T>, T>
implements SubProcessNodeBuilder<T> {
    public SubProcessNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new SubProcessNode(), id);
    }

    protected SubProcessNode getSubProcessNode() {
        return (SubProcessNode)this.getNode();
    }

    public SubProcessNodeFactory<T> processId(String processId) {
        this.getSubProcessNode().setProcessId(processId);
        return this;
    }

    public SubProcessNodeFactory<T> waitForCompletion(boolean waitForCompletion) {
        this.getSubProcessNode().setWaitForCompletion(waitForCompletion);
        return this;
    }

    public SubProcessNodeFactory<T> inMapping(String parameterName, String variableName) {
        this.getSubProcessNode().addInMapping(parameterName, variableName);
        return this;
    }

    public SubProcessNodeFactory<T> outMapping(String parameterName, String variableName) {
        this.getSubProcessNode().addOutMapping(parameterName, variableName);
        return this;
    }

    public SubProcessNodeFactory<T> independent(boolean independent) {
        this.getSubProcessNode().setIndependent(independent);
        return this;
    }

    public SubProcessNodeFactory<T> onEntryAction(String dialect, String action) {
        if (this.getSubProcessNode().getActions(dialect) != null) {
            this.getSubProcessNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getSubProcessNode().setActions("onEntry", actions);
        }
        return this;
    }

    public SubProcessNodeFactory<T> onExitAction(String dialect, String action) {
        if (this.getSubProcessNode().getActions(dialect) != null) {
            this.getSubProcessNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getSubProcessNode().setActions("onExit", actions);
        }
        return this;
    }

    public SubProcessNodeFactory<T> timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getSubProcessNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }

    public SubProcessNodeBuilder<T> onEntryAction(Dialect dialect, String action) {
        return this.onEntryAction(DialectConverter.fromDialect(dialect), action);
    }

    public SubProcessNodeBuilder<T> onExitAction(Dialect dialect, String action) {
        return this.onExitAction(DialectConverter.fromDialect(dialect), action);
    }

    public SubProcessNodeBuilder<T> timer(String delay, String period, Dialect dialect, String action) {
        return this.timer(delay, period, DialectConverter.fromDialect(dialect), action);
    }
}

