/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.type;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.jbpm.process.core.datatype.DataType;
import org.kie.soup.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDataType
implements DataType {
    private static final Logger logger = LoggerFactory.getLogger(ObjectDataType.class);
    private static final long serialVersionUID = 510L;
    private String className;
    private ClassLoader classLoader;
    private static final Collection<String> prefixes = Arrays.asList("java.lang", "java.util", "java.time");
    private static Collection<DateFormat> dateFormats = Arrays.asList(new SimpleDateFormat("yyyy-MM-ddHH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("HH:mm:ss"), DateFormat.getDateInstance(), DateFormat.getTimeInstance(), DateFormat.getDateTimeInstance());

    public ObjectDataType() {
    }

    public ObjectDataType(String className) {
        this.setClassName(className);
    }

    public ObjectDataType(String className, ClassLoader classLoader) {
        this.setClassName(className);
        this.setClassLoader(classLoader);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
    }

    private Optional<Class<?>> getClass(Object value) {
        try {
            return Optional.of(Class.forName(this.className, true, value.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            logger.info("Error {} loading class {}", (Object)e, (Object)this.className);
            if (!this.className.contains(".")) {
                for (String prefix : prefixes) {
                    String altName = prefix + "." + this.className;
                    try {
                        return Optional.of(Class.forName(altName, true, this.classLoader));
                    }
                    catch (ClassNotFoundException e2) {
                        logger.debug("Error {} loading class {}", (Object)e2, (Object)altName);
                    }
                }
            }
            return Optional.empty();
        }
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value == null || this.className == null) {
            return true;
        }
        return this.getClass(value).map(c -> c.isInstance(value)).orElse(false);
    }

    private Optional<Object> getObjectFromClass(Object value) {
        Optional<Class<?>> clazz = this.getClass(value);
        if (clazz.isPresent()) {
            Class<?> objectClass = clazz.get();
            if (objectClass.isInstance(value)) {
                return Optional.of(value);
            }
            if (Date.class.isAssignableFrom(objectClass)) {
                return Optional.of(this.parseDate(value.toString()));
            }
            if (LocalDate.class.isAssignableFrom(objectClass)) {
                return Optional.of(LocalDate.parse(value.toString()));
            }
            if (LocalDateTime.class.isAssignableFrom(objectClass)) {
                return Optional.of(LocalDateTime.parse(value.toString()));
            }
            if (ZonedDateTime.class.isAssignableFrom(objectClass)) {
                return Optional.of(ZonedDateTime.parse(value.toString()));
            }
        }
        return Optional.empty();
    }

    private Date parseDate(String toBeParsed) {
        StringBuilder sb = new StringBuilder();
        for (DateFormat dateFormat : dateFormats) {
            try {
                return dateFormat.parse(toBeParsed);
            }
            catch (ParseException ex) {
                sb.append(ex.getMessage()).append(System.lineSeparator());
            }
        }
        throw new IllegalArgumentException(sb.toString());
    }

    @Override
    public Object readValue(String value) {
        return value != null ? this.getObjectFromClass(value).orElseGet(() -> this.getXStream().fromXML(value)) : null;
    }

    @Override
    public Object valueOf(String value) {
        try {
            return value != null ? this.getObjectFromClass(value).orElse(value) : null;
        }
        catch (IllegalArgumentException e) {
            return value;
        }
    }

    @Override
    public String writeValue(Object value) {
        return this.getXStream().toXML(value);
    }

    private XStream getXStream() {
        XStream xstream = XStreamUtils.createTrustingXStream();
        if (this.classLoader != null) {
            Map store;
            xstream.setClassLoader(this.classLoader);
            if (this.classLoader instanceof ProjectClassLoader && (store = ((ProjectClassLoader)this.classLoader).getStore()) != null) {
                String[] classes = (String[])store.keySet().stream().map(s -> s.replace('/', '.')).map(s -> s.endsWith(".class") ? s.substring(0, s.length() - ".class".length()) : s).toArray(String[]::new);
                xstream.addPermission((TypePermission)new ExplicitTypePermission(classes));
            }
        }
        return xstream;
    }

    @Override
    public String getStringType() {
        return this.className == null ? "java.lang.Object" : this.className;
    }
}

