/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.spring5;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.spring5.JdbiUtil;
import org.jdbi.v3.sqlobject.SqlObject;

class JdbiJtaBinder {
    private JdbiJtaBinder() {
        throw new UtilityClassException();
    }

    static <E> E bind(Jdbi jdbi, Class<E> extensionType) {
        InvocationHandler invocationHandler = JdbiJtaBinder.createInvocationHandler(jdbi, extensionType);
        return extensionType.cast(JdbiJtaBinder.createProxy(invocationHandler, extensionType, SqlObject.class));
    }

    private static InvocationHandler createInvocationHandler(Jdbi jdbi, Class<?> extensionType) {
        return (proxy, method, args) -> {
            Handle handle = JdbiUtil.getHandle(jdbi);
            try {
                Object delegate = handle.attach(extensionType);
                Object object = JdbiJtaBinder.invoke(delegate, method, args);
                return object;
            }
            finally {
                JdbiUtil.closeIfNeeded(handle);
            }
        };
    }

    private static Object createProxy(InvocationHandler naiveHandler, Class<?> extensionType, Class<?> ... extraTypes) {
        InvocationHandler handler = (proxy, method, args) -> {
            if (JdbiClassUtils.EQUALS_METHOD.equals(method)) {
                return proxy == args[0];
            }
            if (JdbiClassUtils.HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (JdbiClassUtils.TOSTRING_METHOD.equals(method)) {
                return "JdbiJta on demand proxy for " + extensionType.getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            return naiveHandler.invoke(proxy, method, args);
        };
        Class[] types = (Class[])Stream.of(Stream.of(extensionType), Arrays.stream(extensionType.getInterfaces()), Arrays.stream(extraTypes)).flatMap(Function.identity()).distinct().toArray(Class[]::new);
        return Proxy.newProxyInstance(extensionType.getClassLoader(), types, handler);
    }

    private static Object invoke(Object target, Method method, Object[] args) {
        try {
            if (Proxy.isProxyClass(target.getClass())) {
                return Proxy.getInvocationHandler(target).invoke(target, method, args);
            }
            return MethodHandles.lookup().unreflect(method).bindTo(target).invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw Sneaky.throwAnyway((Throwable)t);
        }
    }
}

