/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.spring5;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdbiUtil {
    private static final Set<Handle> TRANSACTIONAL_HANDLES = Collections.newSetFromMap(new ConcurrentHashMap());

    private JdbiUtil() {
        throw new UtilityClassException();
    }

    public static Handle getHandle(Jdbi jdbi) {
        Handle bound = (Handle)TransactionSynchronizationManager.getResource((Object)jdbi);
        if (bound == null) {
            bound = jdbi.open();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.bindResource((Object)jdbi, (Object)bound);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new Adapter(jdbi, bound));
                TRANSACTIONAL_HANDLES.add(bound);
            }
        }
        return bound;
    }

    public static void closeIfNeeded(Handle handle) {
        if (!TRANSACTIONAL_HANDLES.contains(handle)) {
            handle.close();
        }
    }

    private static class Adapter
    implements TransactionSynchronization {
        private final Jdbi db;
        private final Handle handle;

        Adapter(Jdbi db, Handle handle) {
            this.db = db;
            this.handle = handle;
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.db, (Object)this.handle);
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.db);
        }

        public void beforeCompletion() {
            TRANSACTIONAL_HANDLES.remove(this.handle);
            TransactionSynchronizationManager.unbindResource((Object)this.db);
            this.handle.close();
        }
    }
}

