/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util.v49;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.sqlparser.impl.util.v49.JSqlParserSelectInfoUtil49;
import org.jeecgframework.minidao.sqlparser.impl.vo.SelectSqlInfo;

public class JSqlParserAllTableManager49 {
    private static final Log logger = LogFactory.getLog(JSqlParserAllTableManager49.class);
    private final String sql;
    private final Map<String, SelectSqlInfo> allTableMap = new HashMap<String, SelectSqlInfo>();
    private final Map<String, String> tableAliasMap = new HashMap<String, String>();
    private String parsedSql = null;

    JSqlParserAllTableManager49(String selectSql) {
        this.sql = selectSql;
    }

    public Map<String, SelectSqlInfo> parse() throws JSQLParserException {
        CCJSqlParserManager mgr = new CCJSqlParserManager();
        Statement stmt = mgr.parse((Reader)new StringReader(this.sql));
        if (stmt instanceof Select) {
            PlainSelect plainSelect = ((Select)stmt).getPlainSelect();
            this.parsedSql = plainSelect.toString();
            ArrayList<FromItem> fromItems = new ArrayList<FromItem>();
            fromItems.add(plainSelect.getFromItem());
            List joins = plainSelect.getJoins();
            if (joins != null) {
                joins.forEach(join -> fromItems.add(join.getRightItem()));
            }
            for (FromItem fromItem : fromItems) {
                if (fromItem instanceof Table) {
                    this.addSqlInfoByTable((Table)fromItem);
                    continue;
                }
                if (!(fromItem instanceof ParenthesedSelect)) continue;
                this.handleSubSelect((Select)((ParenthesedSelect)fromItem));
            }
            List selectItems = plainSelect.getSelectItems();
            for (SelectItem selectItem : selectItems) {
                Expression expression = selectItem.getExpression();
                if (expression instanceof AllTableColumns) {
                    SelectSqlInfo sqlInfo;
                    AllTableColumns allTableColumns = (AllTableColumns)expression;
                    String aliasName = allTableColumns.getTable().getName();
                    String tableName = this.tableAliasMap.get(aliasName);
                    if (tableName == null) {
                        tableName = aliasName;
                    }
                    if ((sqlInfo = this.allTableMap.get(tableName)) == null) continue;
                    sqlInfo.setSelectAll(true);
                    sqlInfo.setSelectFields(null);
                    sqlInfo.setRealSelectFields(null);
                    continue;
                }
                if (expression instanceof AllColumns) {
                    String tableName = ((Table)plainSelect.getFromItem(Table.class)).getName();
                    SelectSqlInfo sqlInfo = this.allTableMap.get(tableName);
                    assert (sqlInfo != null);
                    sqlInfo.setSelectAll(true);
                    sqlInfo.setSelectFields(null);
                    sqlInfo.setRealSelectFields(null);
                    continue;
                }
                Alias alias = selectItem.getAlias();
                this.handleExpression(expression, alias, plainSelect.getFromItem());
            }
        } else {
            throw new RuntimeException("\u975e select \u67e5\u8be2sql\uff0c\u4e0d\u505a\u5904\u7406");
        }
        return this.allTableMap;
    }

    private void handleSubSelect(Select subSelect) {
        try {
            String subSelectSql = subSelect.toString();
            Map<String, SelectSqlInfo> map = JSqlParserSelectInfoUtil49.parseAllSelectTable(subSelectSql);
            if (map != null) {
                this.assignMap(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790\u5b50\u67e5\u8be2\u51fa\u9519", (Throwable)e);
        }
    }

    private void handleExpression(Expression expression, Alias alias, FromItem fromItem) {
        if (expression instanceof Function) {
            Function functionExp = (Function)expression;
            ExpressionList expressions = functionExp.getParameters();
            for (Expression expItem : expressions) {
                this.handleExpression(expItem, null, fromItem);
            }
            return;
        }
        if (expression instanceof ParenthesedSelect) {
            this.handleSubSelect((Select)((ParenthesedSelect)expression));
            return;
        }
        if (expression instanceof StringValue || expression instanceof NullValue || expression instanceof LongValue || expression instanceof DoubleValue || expression instanceof HexValue || expression instanceof DateValue || expression instanceof TimestampValue || expression instanceof TimeValue) {
            return;
        }
        if (expression instanceof Column) {
            SelectSqlInfo $sqlInfo;
            String tableName;
            String fieldName;
            Column column = (Column)expression;
            String aliasName = fieldName = column.getColumnName();
            if (alias != null) {
                aliasName = alias.getName();
            }
            if (column.getTable() != null) {
                tableName = column.getTable().getName();
                if (this.tableAliasMap.get(tableName) != null) {
                    tableName = this.tableAliasMap.get(tableName);
                }
            } else {
                tableName = ((Table)fromItem).getName();
            }
            if (($sqlInfo = this.allTableMap.get(tableName)) != null) {
                $sqlInfo.addSelectField(aliasName, fieldName);
            } else {
                logger.warn((Object)("\u53d1\u751f\u610f\u5916\u60c5\u51b5\uff0c\u672a\u627e\u5230\u8868\u540d\u4e3a " + tableName + " \u7684 SelectSqlInfo"));
            }
        }
    }

    private void addSqlInfoByTable(Table table) {
        String tableName = table.getName();
        if (table.getAlias() != null) {
            this.tableAliasMap.put(table.getAlias().getName(), tableName);
        }
        SelectSqlInfo sqlInfo = new SelectSqlInfo(this.parsedSql);
        sqlInfo.setFromTableName(table.getName());
        this.allTableMap.put(sqlInfo.getFromTableName(), sqlInfo);
    }

    private void assignMap(Map<String, SelectSqlInfo> source) {
        for (Map.Entry<String, SelectSqlInfo> entry : source.entrySet()) {
            SelectSqlInfo sqlInfo = this.allTableMap.get(entry.getKey());
            if (sqlInfo == null) {
                this.allTableMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (sqlInfo.getSelectFields() == null) {
                sqlInfo.setSelectFields(entry.getValue().getSelectFields());
            } else {
                sqlInfo.getSelectFields().addAll(entry.getValue().getSelectFields());
            }
            if (sqlInfo.getRealSelectFields() == null) {
                sqlInfo.setRealSelectFields(entry.getValue().getRealSelectFields());
                continue;
            }
            sqlInfo.getRealSelectFields().addAll(entry.getValue().getRealSelectFields());
        }
    }
}

