/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "baseDirFile", "Ljava/io/File;", "(Ljava/io/File;)V", "baseDirPath", "", "toFile", "path", "toPath", "file", "Companion", "kotlin-build-common"})
public class RelativeFileToPathConverter
implements FileToPathConverter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String baseDirPath;
    @Deprecated
    @NotNull
    private static final String PROJECT_DIR_PLACEHOLDER = "$PROJECT_DIR$";

    public RelativeFileToPathConverter(@Nullable File baseDirFile) {
        File file = baseDirFile;
        this.baseDirPath = file != null && (file = file.getCanonicalFile()) != null ? FilesKt.getInvariantSeparatorsPath((File)file) : null;
    }

    @Override
    @NotNull
    public String toPath(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.canonicalFile");
        String path = FilesKt.getInvariantSeparatorsPath((File)file2);
        if (this.baseDirPath != null && StringsKt.startsWith$default((String)path, (String)this.baseDirPath, (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append(PROJECT_DIR_PLACEHOLDER);
            String string2 = path.substring(this.baseDirPath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder.append(string2).toString();
        } else {
            string = path;
        }
        return string;
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path) {
        File file;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)PROJECT_DIR_PLACEHOLDER, (boolean)false, (int)2, null)) {
            String string = this.baseDirPath;
            if (string == null) {
                throw new IllegalStateException("Could not get project root dir".toString());
            }
            String basePath = string;
            StringBuilder stringBuilder = new StringBuilder().append(basePath);
            String string2 = path.substring(PROJECT_DIR_PLACEHOLDER.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            file = new File(stringBuilder.append(string2).toString());
        } else {
            file = new File(path);
        }
        return file;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter$Companion;", "", "()V", "PROJECT_DIR_PLACEHOLDER", "", "kotlin-build-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

