/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.JavaClassProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.KotlinClassInfo;
import org.jetbrains.kotlin.incremental.PathCollectionExternalizer;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ClassAttributesMap;
import org.jetbrains.kotlin.incremental.storage.ConstantExternalizer;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverterKt;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.LinkedHashMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.LongExternalizer;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.SourceToJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringExternalizer;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\tcdefghijkB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050)J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J&\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.J\u0010\u00105\u001a\u00020,2\u0006\u00106\u001a\u000207H\u0014J\u0016\u00108\u001a\n\u0012\u0004\u0012\u000207\u0018\u0001092\u0006\u0010:\u001a\u00020\u0002J\u0010\u0010;\u001a\u0002072\u0006\u0010<\u001a\u000207H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0016J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@09J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020709H\u0016J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020709H\u0016J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u000207H\u0016J\u0018\u0010F\u001a\n\u0012\u0004\u0012\u000207\u0018\u0001092\u0006\u0010G\u001a\u000207H\u0016J\u000e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020@J\u000e\u0010K\u001a\u00020I2\u0006\u0010J\u001a\u00020@J\u000e\u0010L\u001a\u00020I2\u0006\u00100\u001a\u00020\u0002J\u000e\u0010M\u001a\u00020I2\u0006\u0010N\u001a\u00020\u0005J&\u0010O\u001a\u00020,2\u0006\u0010P\u001a\u00020Q2\u000e\u0010R\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010S2\u0006\u0010-\u001a\u00020.J\u0018\u0010T\u001a\u00020,2\u0006\u0010U\u001a\u00020V2\u0006\u0010-\u001a\u00020.H\u0016J6\u0010W\u001a\u00020,2\u0006\u0010J\u001a\u00020@2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u000e\u0010R\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010S2\u0006\u0010-\u001a\u00020.J \u0010X\u001a\u00020,2\b\u0010Y\u001a\u0004\u0018\u00010\u00052\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020.J\u001c\u0010]\u001a\u00020,2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u0005092\u0006\u0010N\u001a\u00020\u0005J\u000e\u0010^\u001a\u00020I2\u0006\u0010N\u001a\u00020\u0005J\u0014\u0010_\u001a\b\u0012\u0004\u0012\u00020\u0005092\u0006\u0010`\u001a\u000207J\f\u0010a\u001a\u00020b*\u00020QH\u0002R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001f\u001a\u00060 R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00060\"R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006l"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "constantsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "feProtoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "internalNameToSource", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "javaSourcesProtoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "multifileFacadeToParts", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "outputDir", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "Lkotlin/Lazy;", "packagePartMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "partToMultifileFacade", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "protoMap", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "classesBySources", "", "sources", "clearCacheForRemovedClasses", "", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "collectClassChangesByFeMetadata", "className", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "stringTable", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "debugLog", "message", "", "getAllPartsOfMultifileFacade", "", "facade", "getClassFilePath", "internalClassName", "getModuleMappingData", "", "getObsoleteJavaClasses", "Lorg/jetbrains/kotlin/name/ClassId;", "getObsoleteMultifileClasses", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "getStableMultifileFacadeParts", "facadeInternalName", "isJavaClassAlreadyInCache", "", "classId", "isJavaClassToTrack", "isMultifileFacade", "isTrackedFile", "file", "saveClassToCache", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "sourceFiles", "", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "saveFrontendClassToCache", "saveJavaClassProto", "source", "serializedJavaClass", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "collector", "saveModuleMappingToCache", "sourceInCache", "sourcesByInternalName", "internalName", "scopeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Companion", "ConstantsMap", "InlineFunctionsMap", "InternalNameToSourcesMap", "JavaSourcesProtoMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "kotlin-build-common"})
public class IncrementalJvmCache
extends AbstractIncrementalCache<JvmClassName>
implements IncrementalCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SourceToJvmNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesJvmNameMap dirtyOutputClassesMap;
    @NotNull
    private final ProtoMap protoMap;
    @NotNull
    private final ProtoMap feProtoMap;
    @NotNull
    private final ConstantsMap constantsMap;
    @NotNull
    private final PackagePartMap packagePartMap;
    @NotNull
    private final MultifileClassFacadeMap multifileFacadeToParts;
    @NotNull
    private final MultifileClassPartMap partToMultifileFacade;
    @NotNull
    private final InlineFunctionsMap inlineFunctionsMap;
    @NotNull
    private final InternalNameToSourcesMap internalNameToSource;
    @NotNull
    private final JavaSourcesProtoMap javaSourcesProtoMap;
    @NotNull
    private final Lazy outputDir$delegate;
    @NotNull
    private static final String PROTO_MAP = "proto";
    @NotNull
    private static final String FE_PROTO_MAP = "fe-proto";
    @NotNull
    private static final String CONSTANTS_MAP = "constants";
    @NotNull
    private static final String PACKAGE_PARTS = "package-parts";
    @NotNull
    private static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    @NotNull
    private static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    @NotNull
    private static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    private static final String INTERNAL_NAME_TO_SOURCE = "internal-name-to-source";
    @NotNull
    private static final String JAVA_SOURCES_PROTO_MAP = "java-sources-proto-map";
    @NotNull
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";

    public IncrementalJvmCache(@NotNull File targetDataRoot, @Nullable File targetOutputDir, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)targetDataRoot, (String)"targetDataRoot");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(new File(targetDataRoot, IncrementalJvmCacheKt.getKOTLIN_CACHE_DIRECTORY_NAME()), pathConverter);
        this.sourceToClassesMap = (SourceToJvmNameMap)this.registerMap((BasicMap)new SourceToJvmNameMap(this.getStorageFile(AbstractIncrementalCache.getSOURCE_TO_CLASSES()), pathConverter));
        this.dirtyOutputClassesMap = (DirtyClassesJvmNameMap)this.registerMap((BasicMap)new DirtyClassesJvmNameMap(this.getStorageFile(AbstractIncrementalCache.getDIRTY_OUTPUT_CLASSES())));
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(PROTO_MAP)));
        this.feProtoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(FE_PROTO_MAP)));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(CONSTANTS_MAP)));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(PACKAGE_PARTS)));
        this.multifileFacadeToParts = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(MULTIFILE_CLASS_FACADES)));
        this.partToMultifileFacade = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(MULTIFILE_CLASS_PARTS)));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(INLINE_FUNCTIONS)));
        this.internalNameToSource = (InternalNameToSourcesMap)this.registerMap((BasicMap)new InternalNameToSourcesMap(this.getStorageFile(INTERNAL_NAME_TO_SOURCE), pathConverter));
        this.javaSourcesProtoMap = (JavaSourcesProtoMap)this.registerMap((BasicMap)new JavaSourcesProtoMap(this.getStorageFile(JAVA_SOURCES_PROTO_MAP)));
        this.outputDir$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(targetOutputDir){
            final /* synthetic */ File $targetOutputDir;
            {
                this.$targetOutputDir = $targetOutputDir;
                super(0);
            }

            @NotNull
            public final File invoke() {
                File file = this.$targetOutputDir;
                if (file == null) {
                    boolean bl = false;
                    String string = "Target is expected to have output directory";
                    throw new IllegalArgumentException(string.toString());
                }
                return file;
            }
        }));
    }

    @NotNull
    public SourceToJvmNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesJvmNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        return (File)lazy.getValue();
    }

    protected void debugLog(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public final boolean isTrackedFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getSourceToClassesMap$kotlin_build_common().contains(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<JvmClassName> classesBySources(@NotNull Iterable<? extends File> sources) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Iterable<? extends File> $this$flatMap$iv = sources;
        boolean $i$f$flatMap = false;
        Iterable<? extends File> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getSourceToClassesMap$kotlin_build_common().get(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean sourceInCache(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getSourceToClassesMap$kotlin_build_common().contains(file);
    }

    @NotNull
    public final Collection<File> sourcesByInternalName(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        return this.internalNameToSource.get(internalName);
    }

    @Nullable
    public final Collection<String> getAllPartsOfMultifileFacade(@NotNull JvmClassName facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        return this.multifileFacadeToParts.get(facade);
    }

    public final boolean isMultifileFacade(@NotNull JvmClassName className2) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        return this.multifileFacadeToParts.contains(className2);
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        String string = FileUtil.toSystemIndependentName((String)new File(this.getOutputDir(), internalClassName + ".class").getCanonicalPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string;
    }

    public final void saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles, @NotNull File file) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)MODULE_MAPPING_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(MODULE_MAPPING_FILE_NAME)");
        JvmClassName jvmClassName2 = jvmClassName;
        this.protoMap.storeModuleMapping(jvmClassName2, FilesKt.readBytes((File)file));
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName2);
        Iterable $this$forEach$iv = sourceFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getSourceToClassesMap$kotlin_build_common().add(it, jvmClassName2);
        }
    }

    public void saveFileToCache(@NotNull GeneratedJvmClass generatedClass, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)generatedClass, (String)"generatedClass");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        this.saveClassToCache(KotlinClassInfo.Companion.createFrom(generatedClass.getOutputClass()), generatedClass.getSourceFiles(), changesCollector);
    }

    public final void saveClassToCache(@NotNull KotlinClassInfo kotlinClassInfo, @Nullable List<? extends File> sourceFiles, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        JvmClassName className2 = kotlinClassInfo.getClassName();
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(className2);
        if (sourceFiles != null) {
            Iterable $this$forEach$iv = sourceFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                this.getSourceToClassesMap$kotlin_build_common().add(it, className2);
            }
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            this.internalNameToSource.set(string, (Collection<? extends File>)sourceFiles);
        }
        if (kotlinClassInfo.getClassId().isLocal()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[kotlinClassInfo.getClassKind().ordinal()]) {
            case 1: {
                if (sourceFiles != null) {
                    boolean bl;
                    boolean bl2 = bl = sourceFiles.size() == 1;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-IncrementalJvmCache$saveClassToCache$32 = false;
                        String $i$a$-assert-IncrementalJvmCache$saveClassToCache$32 = "Package part from several source files: " + sourceFiles;
                        throw new AssertionError((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$32);
                    }
                }
                this.packagePartMap.addPackagePart(className2);
                this.protoMap.process(kotlinClassInfo, changesCollector);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
                break;
            }
            case 2: {
                List partNames = ArraysKt.toList((Object[])kotlinClassInfo.getClassHeaderData());
                if (!(!((Collection)partNames).isEmpty())) {
                    boolean $i$a$-check-IncrementalJvmCache$saveClassToCache$42 = false;
                    String $i$a$-check-IncrementalJvmCache$saveClassToCache$42 = "Multifile class has no parts: " + className2;
                    throw new IllegalStateException($i$a$-check-IncrementalJvmCache$saveClassToCache$42.toString());
                }
                this.multifileFacadeToParts.set(className2, partNames);
                if (this.protoMap.contains(className2)) {
                    FqName fqName = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
                    changesCollector.collectSignature(fqName, true);
                }
                this.protoMap.remove(className2, changesCollector);
                AbstractIncrementalCache.ClassFqNameToSourceMap classFqNameToSourceMap = this.getClassFqNameToSourceMap();
                FqName fqName = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
                classFqNameToSourceMap.remove(fqName);
                ClassAttributesMap classAttributesMap = this.getClassAttributesMap$kotlin_build_common();
                FqName fqName2 = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"className.fqNameForClassNameWithoutDollars");
                classAttributesMap.remove(fqName2);
                String string = className2.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
                this.internalNameToSource.remove(string);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
                break;
            }
            case 3: {
                if (sourceFiles != null) {
                    boolean bl;
                    boolean bl3 = bl = sourceFiles.size() == 1;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-IncrementalJvmCache$saveClassToCache$52 = false;
                        String $i$a$-assert-IncrementalJvmCache$saveClassToCache$52 = "Multifile class part from several source files: " + sourceFiles;
                        throw new AssertionError((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$52);
                    }
                }
                this.packagePartMap.addPackagePart(className2);
                String string = className2.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
                String string2 = kotlinClassInfo.getMultifileClassName();
                Intrinsics.checkNotNull((Object)string2);
                this.partToMultifileFacade.set(string, string2);
                this.protoMap.process(kotlinClassInfo, changesCollector);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
                break;
            }
            case 4: {
                File file;
                IncrementalJvmCache incrementalJvmCache = this;
                ProtoData protoData2 = kotlinClassInfo.getProtoData();
                Intrinsics.checkNotNull((Object)protoData2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ClassProtoData");
                ClassProtoData classProtoData = (ClassProtoData)protoData2;
                List<? extends File> list = sourceFiles;
                if (list != null) {
                    List<? extends File> $i$a$-assert-IncrementalJvmCache$saveClassToCache$52 = list;
                    ClassProtoData classProtoData2 = classProtoData;
                    IncrementalJvmCache incrementalJvmCache2 = incrementalJvmCache;
                    boolean bl = false;
                    File file2 = (File)CollectionsKt.single(sourceFiles);
                    incrementalJvmCache = incrementalJvmCache2;
                    classProtoData = classProtoData2;
                    file = file2;
                } else {
                    file = null;
                }
                incrementalJvmCache.addToClassStorage(classProtoData, file);
                this.protoMap.process(kotlinClassInfo, changesCollector);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
            }
        }
    }

    public final void saveFrontendClassToCache(@NotNull ClassId classId, @NotNull ProtoBuf.Class classProto, @NotNull JvmStringTable stringTable, @Nullable List<? extends File> sourceFiles, @NotNull ChangesCollector changesCollector) {
        File file;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        JvmClassName jvmClassName = JvmClassName.byClassId((ClassId)classId);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(classId)");
        JvmClassName className2 = jvmClassName;
        if (sourceFiles != null) {
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            this.internalNameToSource.set(string, (Collection<? extends File>)sourceFiles);
        }
        if (classId.isLocal()) {
            return;
        }
        ClassProtoData newProtoData = new ClassProtoData(classProto, stringTable.toNameResolver());
        IncrementalJvmCache incrementalJvmCache = this;
        ClassProtoData classProtoData = newProtoData;
        List<? extends File> list = sourceFiles;
        if (list != null) {
            List<? extends File> list2 = list;
            ClassProtoData classProtoData2 = classProtoData;
            IncrementalJvmCache incrementalJvmCache2 = incrementalJvmCache;
            boolean bl = false;
            File file2 = (File)CollectionsKt.single(sourceFiles);
            incrementalJvmCache = incrementalJvmCache2;
            classProtoData = classProtoData2;
            file = file2;
        } else {
            file = null;
        }
        incrementalJvmCache.addToClassStorage(classProtoData, file);
        byte[] byArray = JvmProtoBufUtil.writeDataBytes((JvmStringTable)stringTable, (MessageLite)((MessageLite)classProto));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeDataBytes(stringTable, classProto)");
        Collection $this$toTypedArray$iv = stringTable.getStrings();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        this.feProtoMap.putAndCollect(className2, new ProtoMapValue(false, byArray, stringArray), newProtoData, changesCollector);
    }

    public final void collectClassChangesByFeMetadata(@NotNull JvmClassName className2, @NotNull ProtoBuf.Class classProto, @NotNull JvmStringTable stringTable, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        this.feProtoMap.check$kotlin_build_common(className2, classProto, stringTable, changesCollector);
    }

    public final void saveJavaClassProto(@Nullable File source, @NotNull SerializedJavaClass serializedJavaClass, @NotNull ChangesCollector collector) {
        Intrinsics.checkNotNullParameter((Object)serializedJavaClass, (String)"serializedJavaClass");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        JvmClassName jvmClassName = JvmClassName.byClassId((ClassId)serializedJavaClass.getClassId());
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(serializedJavaClass.classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        this.javaSourcesProtoMap.process(jvmClassName2, serializedJavaClass, collector);
        File file = source;
        if (file != null) {
            File it = file;
            boolean bl = false;
            this.getSourceToClassesMap$kotlin_build_common().add(source, jvmClassName2);
        }
        this.addToClassStorage(JavaClassesTrackerImplKt.toProtoData(serializedJavaClass), source);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ClassId> getObsoleteJavaClasses() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JvmClassName it = (JvmClassName)element$iv$iv;
            boolean bl2 = false;
            SerializedJavaClass serializedJavaClass = this.javaSourcesProtoMap.get(it);
            if ((serializedJavaClass != null ? serializedJavaClass.getClassId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isJavaClassToTrack(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JvmClassName jvmClassName = JvmClassName.byClassId((ClassId)classId);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        return this.getDirtyOutputClassesMap$kotlin_build_common().isDirty(jvmClassName2) || !this.javaSourcesProtoMap.contains(jvmClassName2);
    }

    public final boolean isJavaClassAlreadyInCache(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JvmClassName jvmClassName = JvmClassName.byClassId((ClassId)classId);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        return this.javaSourcesProtoMap.contains(jvmClassName2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable answer$iv;
        Object facade;
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Collection dirtyClasses = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        HashMap facadesWithRemovedParts = new HashMap();
        for (JvmClassName jvmClassName : dirtyClasses) {
            Object object;
            JvmClassName facadeClassName;
            if (this.partToMultifileFacade.get(jvmClassName) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)JvmClassName.byInternalName((String)facade), (String)"byInternalName(facade)");
            Map $this$getOrPut$iv = facadesWithRemovedParts;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(facadeClassName);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new HashSet();
                $this$getOrPut$iv.put(facadeClassName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set removedParts = (Set)object;
            String string = jvmClassName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dirtyClass.internalName");
            removedParts.add(string);
        }
        for (Map.Entry entry : facadesWithRemovedParts.entrySet()) {
            void $this$filterTo$iv$iv;
            Collection<String> allParts;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"facadesWithRemovedParts.entries");
            facade = (JvmClassName)entry.getKey();
            Set removedParts = (Set)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)facade, (String)"facade");
            if (this.multifileFacadeToParts.get((JvmClassName)facade) == null) continue;
            Iterable $this$filter$iv = allParts;
            boolean $i$f$filter = false;
            answer$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!removedParts.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notRemovedParts = (List)destination$iv$iv;
            if (notRemovedParts.isEmpty()) {
                this.multifileFacadeToParts.remove((JvmClassName)facade);
                continue;
            }
            this.multifileFacadeToParts.set((JvmClassName)facade, notRemovedParts);
        }
        Iterable $this$forEach$iv = dirtyClasses;
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            JvmClassName it = (JvmClassName)element$iv;
            boolean bl2 = false;
            this.protoMap.remove(it, changesCollector);
            this.feProtoMap.remove(it, changesCollector);
            this.packagePartMap.remove(it);
            this.multifileFacadeToParts.remove(it);
            this.partToMultifileFacade.remove(it);
            this.constantsMap.remove(it);
            this.inlineFunctionsMap.remove(it);
            String string = it.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.internalName");
            this.internalNameToSource.remove(string);
            this.javaSourcesProtoMap.remove(it, changesCollector);
        }
        $this$forEach$iv = dirtyClasses;
        IncrementalJvmCache incrementalJvmCache = this;
        boolean bl3 = false;
        facade = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmClassName $i$f$filter = (JvmClassName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            FqName fqName = it.getFqNameForClassNameWithoutDollars();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"it.fqNameForClassNameWithoutDollars");
            collection.add(fqName);
        }
        incrementalJvmCache.removeAllFromClassStorage((List)destination$iv$iv, changesCollector);
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        PackagePartMap packagePartMap = this.packagePartMap;
        boolean $i$f$filter22 = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JvmClassName p0 = (JvmClassName)element$iv$iv;
            boolean bl = false;
            if (!packagePartMap.isPackagePart(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List obsoletePackageParts = (List)destination$iv$iv;
        this.debugLog("Obsolete package parts: " + obsoletePackageParts);
        Iterable $this$map$iv = obsoletePackageParts;
        boolean $i$f$map = false;
        Iterable $i$f$filter22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (JvmClassName)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getInternalName());
        }
        return (List)destination$iv$iv2;
    }

    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)partInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(partInternalName)");
        ProtoMapValue protoMapValue2 = this.protoMap.get(jvmClassName);
        if (protoMapValue2 != null) {
            ProtoMapValue value = protoMapValue2;
            boolean bl = false;
            jvmPackagePartProto = new JvmPackagePartProto(value.getBytes(), value.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet<String> obsoleteMultifileClasses = new LinkedHashSet<String>();
        for (JvmClassName dirtyClass : this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.partToMultifileFacade.get(dirtyClass) == null) continue;
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        this.debugLog("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)facadeInternalName, (String)"facadeInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)facadeInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(facadeInternalName)");
        JvmClassName jvmClassName2 = jvmClassName;
        Collection<String> collection = this.multifileFacadeToParts.get(jvmClassName2);
        if (collection == null) {
            return null;
        }
        Collection<String> partNames = collection;
        Iterable $this$filter$iv = partNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            DirtyClassesJvmNameMap dirtyClassesJvmNameMap = this.getDirtyOutputClassesMap$kotlin_build_common();
            JvmClassName jvmClassName3 = JvmClassName.byInternalName((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName3, (String)"byInternalName(it)");
            if (!(!dirtyClassesJvmNameMap.isDirty(jvmClassName3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)MODULE_MAPPING_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue2 = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue2 != null ? protoMapValue2.getBytes() : null);
    }

    private final FqName scopeFqName(KotlinClassInfo $this$scopeFqName) {
        FqName fqName = WhenMappings.$EnumSwitchMapping$0[$this$scopeFqName.getClassKind().ordinal()] == 4 ? $this$scopeFqName.getClassId().asSingleFqName() : $this$scopeFqName.getClassId().getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"when (classKind) {\n     \u2026assId.packageFqName\n    }");
        return fqName;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$Companion;", "", "()V", "CONSTANTS_MAP", "", "FE_PROTO_MAP", "INLINE_FUNCTIONS", "INTERNAL_NAME_TO_SOURCE", "JAVA_SOURCES_PROTO_MAP", "MODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "PROTO_MAP", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020!\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "check", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "stringTable", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "check$kotlin_build_common", "contains", "", "dumpValue", "", "value", "get", "process", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "putAndCollect", "newMapValue", "newProtoData", "Lorg/jetbrains/kotlin/incremental/ProtoData;", "remove", "storeModuleMapping", "bytes", "", "kotlin-build-common"})
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        public ProtoMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }

        public final synchronized void process(@NotNull KotlinClassInfo kotlinClassInfo, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            this.putAndCollect(kotlinClassInfo.getClassName(), kotlinClassInfo.getProtoMapValue(), kotlinClassInfo.getProtoData(), changesCollector);
        }

        public final synchronized void storeModuleMapping(@NotNull JvmClassName className2, @NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            LazyStorage<String, ProtoMapValue> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            boolean $i$f$emptyArray = false;
            lazyStorage.set(string, new ProtoMapValue(false, bytes, (String[])((Object[])new String[0])));
        }

        public final synchronized void putAndCollect(@NotNull JvmClassName className2, @NotNull ProtoMapValue newMapValue, @NotNull ProtoData newProtoData, @NotNull ChangesCollector changesCollector) {
            ProtoData protoData2;
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)newMapValue, (String)"newMapValue");
            Intrinsics.checkNotNullParameter((Object)newProtoData, (String)"newProtoData");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            String key = string;
            ProtoMapValue oldMapValue = (ProtoMapValue)this.getStorage().get(key);
            this.getStorage().set(key, newMapValue);
            ProtoMapValue protoMapValue2 = oldMapValue;
            if (protoMapValue2 != null) {
                FqName fqName = className2.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"className.packageFqName");
                protoData2 = ProtoDifferenceUtilsKt.toProtoData(protoMapValue2, fqName);
            } else {
                protoData2 = null;
            }
            ChangesCollector.collectProtoChanges$default(changesCollector, protoData2, newProtoData, false, key, 4, null);
        }

        public final void check$kotlin_build_common(@NotNull JvmClassName className2, @NotNull ProtoBuf.Class classProto, @NotNull JvmStringTable stringTable, @NotNull ChangesCollector changesCollector) {
            ProtoData protoData2;
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
            Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            String key = string;
            ProtoMapValue protoMapValue2 = (ProtoMapValue)this.getStorage().get(key);
            if (protoMapValue2 != null) {
                FqName fqName = className2.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"className.packageFqName");
                protoData2 = ProtoDifferenceUtilsKt.toProtoData(protoMapValue2, fqName);
            } else {
                protoData2 = null;
            }
            ProtoData oldProtoData = protoData2;
            ClassProtoData newProtoData = new ClassProtoData(classProto, stringTable.toNameResolver());
            ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoData, newProtoData, false, key, 4, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final synchronized void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            String key = string;
            ProtoMapValue protoMapValue2 = (ProtoMapValue)this.getStorage().get(key);
            if (protoMapValue2 == null) {
                return;
            }
            ProtoMapValue oldValue = protoMapValue2;
            if (!Intrinsics.areEqual((Object)key, (Object)MODULE_MAPPING_FILE_NAME)) {
                FqName fqName = className2.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"className.packageFqName");
                ChangesCollector.collectProtoChanges$default(changesCollector, ProtoDifferenceUtilsKt.toProtoData(oldValue, fqName), null, false, null, 12, null);
            }
            this.getStorage().remove(key);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (value.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalJvmCacheKt.md5(value.getBytes()));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "jvmClassName", "newData", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class JavaSourcesProtoMap
    extends BasicStringMap<SerializedJavaClass> {
        public JavaSourcesProtoMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, JavaClassProtoMapValueExternalizer.INSTANCE);
        }

        public final synchronized void process(@NotNull JvmClassName jvmClassName, @NotNull SerializedJavaClass newData, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
            Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string = jvmClassName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jvmClassName.internalName");
            String key = string;
            SerializedJavaClass oldData = (SerializedJavaClass)this.getStorage().get(key);
            this.getStorage().set(key, newData);
            SerializedJavaClass serializedJavaClass = oldData;
            ChangesCollector.collectProtoChanges$default(changesCollector, serializedJavaClass != null ? JavaClassesTrackerImplKt.toProtoData(serializedJavaClass) : null, JavaClassesTrackerImplKt.toProtoData(newData), true, null, 8, null);
        }

        public final synchronized void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            String key = string;
            SerializedJavaClass serializedJavaClass = (SerializedJavaClass)this.getStorage().get(key);
            if (serializedJavaClass == null) {
                return;
            }
            SerializedJavaClass oldValue = serializedJavaClass;
            this.getStorage().remove(key);
            ChangesCollector.collectProtoChanges$default(changesCollector, JavaClassesTrackerImplKt.toProtoData(oldValue), null, false, null, 12, null);
        }

        @Nullable
        public final SerializedJavaClass get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return (SerializedJavaClass)lazyStorage.get(string);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull SerializedJavaClass value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] byArray = value.getProto().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.proto.toByteArray()");
            String string = Long.toHexString(IncrementalJvmCacheKt.md5(byArray));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(value.proto.toByteArray().md5())");
            return string;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J,\u0010\r\u001a\u00020\u00032\"\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u0005H\u0014J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "process", "", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class ConstantsMap
    extends BasicStringMap<LinkedHashMap<String, Object>> {
        public ConstantsMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, ConstantExternalizer.INSTANCE));
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        public final synchronized void process(@NotNull KotlinClassInfo kotlinClassInfo, @NotNull ChangesCollector changesCollector) {
            FqName companionObjectClassId;
            FqName fqName;
            FqName fqName2;
            Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string = kotlinClassInfo.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinClassInfo.className.internalName");
            String key = string;
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.getStorage().get(key);
            Map oldMap2 = linkedHashMap != null ? (Map)linkedHashMap : MapsKt.emptyMap();
            LinkedHashMap<String, Object> newMap2 = kotlinClassInfo.getConstantsMap();
            if (!((Map)newMap2).isEmpty()) {
                this.getStorage().set(key, newMap2);
            } else {
                this.getStorage().remove(key);
            }
            Set set = oldMap2.keySet();
            Set<String> set2 = newMap2.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"newMap.keys");
            Set allConstants = SetsKt.plus(set, (Iterable)set2);
            if (allConstants.isEmpty()) {
                return;
            }
            if (kotlinClassInfo.getClassKind() == KotlinClassHeader.Kind.CLASS) {
                ProtoData protoData2 = kotlinClassInfo.getProtoData();
                Intrinsics.checkNotNull((Object)protoData2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ClassProtoData");
                ClassProtoData protoData3 = (ClassProtoData)protoData2;
                if (protoData3.getProto().hasCompanionObjectName()) {
                    Name name = Name.identifier((String)protoData3.getNameResolver().getString(protoData3.getProto().getCompanionObjectName()));
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(protoData.nam\u2026oto.companionObjectName))");
                    Name companionObjectName = name;
                    fqName2 = kotlinClassInfo.getClassId().createNestedClassId(companionObjectName);
                } else {
                    fqName2 = null;
                }
            } else {
                fqName2 = null;
            }
            if ((fqName = (companionObjectClassId = fqName2)) == null || (fqName = fqName.asSingleFqName()) == null) {
                fqName = IncrementalJvmCache.this.scopeFqName(kotlinClassInfo);
            }
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"companionObjectClassId?.\u2026inClassInfo.scopeFqName()");
            FqName scope = fqName;
            for (String string2 : allConstants) {
                changesCollector.collectMemberIfValueWasChanged(scope, string2, oldMap2.get(string2), newMap2.get(string2));
            }
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull LinkedHashMap<String, Object> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return IncrementalJvmCacheKt.dumpMap((Map)value, dumpValue.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove", "kotlin-build-common"})
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public PackagePartMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)booleanDataDescriptor, (String)"INSTANCE");
            super(storageFile, (DataExternalizer)booleanDataDescriptor);
        }

        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "get", "remove", "", "set", "partNames", "kotlin-build-common"})
    private final class MultifileClassFacadeMap
    extends BasicStringMap<Collection<? extends String>> {
        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }

        public final synchronized void set(@NotNull JvmClassName className2, @NotNull Collection<String> partNames) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter(partNames, (String)"partNames");
            LazyStorage<String, Collection<String>> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            lazyStorage.set(string, partNames);
        }

        @Nullable
        public final Collection<String> get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return (Collection)lazyStorage.get(string);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "get", "partName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "remove", "", "className", "set", "facadeName", "kotlin-build-common"})
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
            super(storageFile, (DataExternalizer)enumeratorStringDescriptor);
        }

        public final synchronized void set(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
            Intrinsics.checkNotNullParameter((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String get(@NotNull JvmClassName partName) {
            Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
            LazyStorage lazyStorage = this.getStorage();
            String string = partName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"partName.internalName");
            return (String)lazyStorage.get(string);
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003J\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "value", "get", "internalName", "remove", "", "set", "sourceFiles", "kotlin-build-common"})
    public final class InternalNameToSourcesMap
    extends BasicStringMap<Collection<? extends String>> {
        @NotNull
        private final FileToPathConverter pathConverter;

        public InternalNameToSourcesMap(@NotNull File storageFile, FileToPathConverter pathConverter) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
            super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)new EnumeratorStringDescriptor()), (DataExternalizer)PathCollectionExternalizer.INSTANCE);
            this.pathConverter = pathConverter;
        }

        public final void set(@NotNull String internalName, @NotNull Collection<? extends File> sourceFiles) {
            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
            Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
            this.getStorage().set(internalName, FileToPathConverterKt.toPaths(this.pathConverter, sourceFiles));
        }

        @NotNull
        public final Collection<File> get(@NotNull String internalName) {
            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
            Collection collection = (Collection)this.getStorage().get(internalName);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            return FileToPathConverterKt.toFiles(this.pathConverter, collection);
        }

        public final void remove(@NotNull String internalName) {
            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
            this.getStorage().remove(internalName);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\u00020\u00032\"\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u0005H\u0014J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "functionNameBySignature", "signature", "process", "", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "kotlin-build-common"})
    private final class InlineFunctionsMap
    extends BasicStringMap<LinkedHashMap<String, Long>> {
        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, LongExternalizer.INSTANCE));
        }

        public final synchronized void process(@NotNull KotlinClassInfo kotlinClassInfo, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string = kotlinClassInfo.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinClassInfo.className.internalName");
            String key = string;
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.getStorage().get(key);
            Map oldMap2 = linkedHashMap != null ? (Map)linkedHashMap : MapsKt.emptyMap();
            LinkedHashMap<String, Long> newMap2 = kotlinClassInfo.getInlineFunctionsMap();
            if (!((Map)newMap2).isEmpty()) {
                this.getStorage().set(key, newMap2);
            } else {
                this.getStorage().remove(key);
            }
            Set set = oldMap2.keySet();
            Set<String> set2 = newMap2.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"newMap.keys");
            for (String fn : SetsKt.plus(set, (Iterable)set2)) {
                changesCollector.collectMemberIfValueWasChanged(IncrementalJvmCache.this.scopeFqName(kotlinClassInfo), this.functionNameBySignature(fn), oldMap2.get(fn), newMap2.get(fn));
            }
        }

        private final String functionNameBySignature(String signature) {
            return StringsKt.substringBefore$default((String)signature, (String)"(", null, (int)2, null);
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull LinkedHashMap<String, Long> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return IncrementalJvmCacheKt.dumpMap((Map)value, dumpValue.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 1;
            nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 2;
            nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 4;
            nArray[KotlinClassHeader.Kind.UNKNOWN.ordinal()] = 5;
            nArray[KotlinClassHeader.Kind.SYNTHETIC_CLASS.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

