/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.NameTransformer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/JvmClassNameTransformer;", "Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "<init>", "()V", "asString", "", "name", "asName", "string", "asFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin-build-common"})
public final class JvmClassNameTransformer
implements NameTransformer<JvmClassName> {
    @NotNull
    public static final JvmClassNameTransformer INSTANCE = new JvmClassNameTransformer();

    private JvmClassNameTransformer() {
    }

    @Override
    @NotNull
    public String asString(@NotNull JvmClassName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        return string;
    }

    @Override
    @NotNull
    public JvmClassName asName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        return jvmClassName;
    }

    @Override
    @NotNull
    public FqName asFqName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        FqName fqName = this.asName(string).getFqNameForClassNameWithoutDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"getFqNameForClassNameWithoutDollars(...)");
        return fqName;
    }
}

