/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.compat;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.BuildOperation;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.ExecutionPolicy;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.KotlinToolchains;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.internal.compat.BuildOperationImpl;
import org.jetbrains.kotlin.buildtools.internal.compat.ExecutionPolicyV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.JvmClasspathSnapshottingOperationV1Adapter;
import org.jetbrains.kotlin.buildtools.internal.compat.JvmCompilationOperationV1Adapter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J3\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/compat/BuildSessionV1Adapter;", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains$BuildSession;", "kotlinToolchains", "Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;", "projectId", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "compilationService", "Lorg/jetbrains/kotlin/buildtools/api/CompilationService;", "<init>", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;Lorg/jetbrains/kotlin/buildtools/api/ProjectId;Lorg/jetbrains/kotlin/buildtools/api/CompilationService;)V", "getKotlinToolchains", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinToolchains;", "getProjectId", "()Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "executeOperation", "R", "operation", "Lorg/jetbrains/kotlin/buildtools/api/BuildOperation;", "(Lorg/jetbrains/kotlin/buildtools/api/BuildOperation;)Ljava/lang/Object;", "executionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/jetbrains/kotlin/buildtools/api/BuildOperation;Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)Ljava/lang/Object;", "close", "", "kotlin-build-tools-compat"})
@SourceDebugExtension(value={"SMAP\nKotlinToolchainsV1Adapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolchainsV1Adapter.kt\norg/jetbrains/kotlin/buildtools/internal/compat/BuildSessionV1Adapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,402:1\n1#2:403\n*E\n"})
final class BuildSessionV1Adapter
implements KotlinToolchains.BuildSession {
    @NotNull
    private final KotlinToolchains kotlinToolchains;
    @NotNull
    private final ProjectId projectId;
    @NotNull
    private final CompilationService compilationService;

    public BuildSessionV1Adapter(@NotNull KotlinToolchains kotlinToolchains, @NotNull ProjectId projectId, @NotNull CompilationService compilationService) {
        Intrinsics.checkNotNullParameter((Object)kotlinToolchains, (String)"kotlinToolchains");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)compilationService, (String)"compilationService");
        this.kotlinToolchains = kotlinToolchains;
        this.projectId = projectId;
        this.compilationService = compilationService;
    }

    @NotNull
    public KotlinToolchains getKotlinToolchains() {
        return this.kotlinToolchains;
    }

    @NotNull
    public ProjectId getProjectId() {
        return this.projectId;
    }

    public <R> R executeOperation(@NotNull BuildOperation<R> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return (R)KotlinToolchains.BuildSession.executeOperation$default((KotlinToolchains.BuildSession)this, operation, null, null, (int)2, null);
    }

    public <R> R executeOperation(@NotNull BuildOperation<R> operation, @NotNull ExecutionPolicy executionPolicy, @Nullable KotlinLogger logger) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)executionPolicy, (String)"executionPolicy");
        if (!(executionPolicy instanceof ExecutionPolicyV1Adapter)) {
            boolean bl = false;
            String string = "Unsupported execution mode. Execution mode must be obtained from `createInProcessExecutionPolicy` or `createDaemonExecutionPolicy`.";
            throw new IllegalArgumentException(string.toString());
        }
        BuildOperation<R> buildOperation = operation;
        if (!(buildOperation instanceof JvmCompilationOperationV1Adapter) && !(buildOperation instanceof JvmClasspathSnapshottingOperationV1Adapter)) {
            throw new IllegalStateException(("Unsupported operation type with BTA API v1 fallback (compiler version " + this.getKotlinToolchains().getCompilerVersion() + ": " + Reflection.getOrCreateKotlinClass(operation.getClass()).getSimpleName() + ").").toString());
        }
        return ((BuildOperationImpl)operation).execute(this.getProjectId(), (ExecutionPolicyV1Adapter)executionPolicy, logger);
    }

    public void close() {
        this.compilationService.finishProjectCompilation(this.getProjectId());
    }
}

