/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.internal.KotlinMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/KotlinLoggerMessageCollectorAdapter;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "kotlinLogger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "<init>", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)V", "getKotlinLogger$kotlin_build_tools_impl", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "clear", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "hasErrors", "", "kotlin-build-tools-impl"})
public final class KotlinLoggerMessageCollectorAdapter
implements MessageCollector {
    @NotNull
    private final KotlinLogger kotlinLogger;

    public KotlinLoggerMessageCollectorAdapter(@NotNull KotlinLogger kotlinLogger) {
        Intrinsics.checkNotNullParameter((Object)kotlinLogger, (String)"kotlinLogger");
        this.kotlinLogger = kotlinLogger;
    }

    @NotNull
    public final KotlinLogger getKotlinLogger$kotlin_build_tools_impl() {
        return this.kotlinLogger;
    }

    public void clear() {
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String renderedMessage = KotlinMessageRenderer.INSTANCE.render(severity, message, location);
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                this.kotlinLogger.error(renderedMessage, (Throwable)new RuntimeException(message));
                break;
            }
            case 2: {
                KotlinLogger.error$default((KotlinLogger)this.kotlinLogger, (String)renderedMessage, null, (int)2, null);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.kotlinLogger.warn(renderedMessage);
                break;
            }
            case 6: {
                this.kotlinLogger.info(renderedMessage);
                break;
            }
            case 7: 
            case 8: {
                this.kotlinLogger.debug(renderedMessage);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public boolean hasErrors() {
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerMessageSeverity.values().length];
            try {
                nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.FIXED_WARNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.INFO.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.OUTPUT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.LOGGING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

